/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaLDAExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaLDAExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_lda_libsvm_data.txt");
        LDA lda = new LDA().setK(10).setMaxIter(10);
        LDAModel model = lda.fit(dataset);
        double ll = model.logLikelihood(dataset);
        double lp = model.logPerplexity(dataset);
        System.out.println("The lower bound on the log likelihood of the entire corpus: " + ll);
        System.out.println("The upper bound bound on perplexity: " + lp);
        Dataset topics = model.describeTopics(3);
        System.out.println("The topics described by their top-weighted terms:");
        topics.show(false);
        Dataset transformed = model.transform(dataset);
        transformed.show(false);
        spark.stop();
    }
}

