/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.spark.examples.LocalALS$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class LocalALS$ {
    public static final LocalALS$ MODULE$;
    private int M;
    private int U;
    private int F;
    private int ITERATIONS;
    private final double LAMBDA;

    static {
        new LocalALS$();
    }

    public int M() {
        return this.M;
    }

    public void M_$eq(int x$1) {
        this.M = x$1;
    }

    public int U() {
        return this.U;
    }

    public void U_$eq(int x$1) {
        this.U = x$1;
    }

    public int F() {
        return this.F;
    }

    public void F_$eq(int x$1) {
        this.F = x$1;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        this.ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return this.LAMBDA;
    }

    public RealMatrix generateR() {
        RealMatrix mh = this.randomMatrix(this.M(), this.F());
        RealMatrix uh = this.randomMatrix(this.U(), this.F());
        return mh.multiply(uh.transpose());
    }

    public double rmse(RealMatrix targetR, RealVector[] ms, RealVector[] us) {
        Array2DRowRealMatrix r = new Array2DRowRealMatrix(this.M(), this.U());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(ms, us, r){
            public static final long serialVersionUID = 0L;
            public final RealVector[] ms$1;
            public final RealVector[] us$1;
            public final Array2DRowRealMatrix r$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.1 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.r$1.setEntry(this.i$2, j, this.$outer.ms$1[this.i$2].dotProduct(this.$outer.us$1[j]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.ms$1 = ms$1;
                this.us$1 = us$1;
                this.r$1 = r$1;
            }
        });
        RealMatrix diffs = r.subtract(targetR);
        DoubleRef sumSqs = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(diffs, sumSqs){
            public static final long serialVersionUID = 0L;
            public final RealMatrix diffs$1;
            public final DoubleRef sumSqs$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.2 $outer;
                    private final int i$3;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        double diff = this.$outer.diffs$1.getEntry(this.i$3, j);
                        this.$outer.sumSqs$1.elem += diff * diff;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$3 = i$3;
                    }
                });
            }
            {
                this.diffs$1 = diffs$1;
                this.sumSqs$1 = sumSqs$1;
            }
        });
        return package$.MODULE$.sqrt(sumSqs.elem / ((double)this.M() * (double)this.U()));
    }

    public RealVector updateMovie(int i, RealVector m, RealVector[] us, RealMatrix R) {
        ObjectRef XtX = ObjectRef.create((Object)new Array2DRowRealMatrix(this.F(), this.F()));
        ObjectRef Xty = ObjectRef.create((Object)new ArrayRealVector(this.F()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.U()).foreach$mVc$sp((Function1)new Serializable(i, us, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int i$1;
            private final RealVector[] us$2;
            private final RealMatrix R$1;
            private final ObjectRef XtX$1;
            private final ObjectRef Xty$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                RealVector u = this.us$2[j];
                this.XtX$1.elem = ((RealMatrix)this.XtX$1.elem).add(u.outerProduct(u));
                this.Xty$1.elem = ((RealVector)this.Xty$1.elem).add(u.mapMultiply(this.R$1.getEntry(this.i$1, j)));
            }
            {
                this.i$1 = i$1;
                this.us$2 = us$2;
                this.R$1 = R$1;
                this.XtX$1 = XtX$1;
                this.Xty$1 = Xty$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)new Serializable(XtX){
            public static final long serialVersionUID = 0L;
            private final ObjectRef XtX$1;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                ((RealMatrix)this.XtX$1.elem).addToEntry(d, d, LocalALS$.MODULE$.LAMBDA() * (double)LocalALS$.MODULE$.U());
            }
            {
                this.XtX$1 = XtX$1;
            }
        });
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public RealVector updateUser(int j, RealVector u, RealVector[] ms, RealMatrix R) {
        ObjectRef XtX = ObjectRef.create((Object)new Array2DRowRealMatrix(this.F(), this.F()));
        ObjectRef Xty = ObjectRef.create((Object)new ArrayRealVector(this.F()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(j, ms, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int j$1;
            private final RealVector[] ms$2;
            private final RealMatrix R$2;
            private final ObjectRef XtX$2;
            private final ObjectRef Xty$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RealVector m = this.ms$2[i];
                this.XtX$2.elem = ((RealMatrix)this.XtX$2.elem).add(m.outerProduct(m));
                this.Xty$2.elem = ((RealVector)this.Xty$2.elem).add(m.mapMultiply(this.R$2.getEntry(i, this.j$1)));
            }
            {
                this.j$1 = j$1;
                this.ms$2 = ms$2;
                this.R$2 = R$2;
                this.XtX$2 = XtX$2;
                this.Xty$2 = Xty$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)new Serializable(XtX){
            public static final long serialVersionUID = 0L;
            private final ObjectRef XtX$2;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                ((RealMatrix)this.XtX$2.elem).addToEntry(d, d, LocalALS$.MODULE$.LAMBDA() * (double)LocalALS$.MODULE$.M());
            }
            {
                this.XtX$2 = XtX$2;
            }
        });
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of ALS and is given as an example!\n        |Please use org.apache.spark.ml.recommendation.ALS\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            String m = (String)((SeqLike)option.get()).apply(0);
            String u = (String)((SeqLike)option.get()).apply(1);
            String f = (String)((SeqLike)option.get()).apply(2);
            String iters = (String)((SeqLike)option.get()).apply(3);
            this.M_$eq(new StringOps(Predef$.MODULE$.augmentString(m)).toInt());
            this.U_$eq(new StringOps(Predef$.MODULE$.augmentString(u)).toInt());
            this.F_$eq(new StringOps(Predef$.MODULE$.augmentString(f)).toInt());
            this.ITERATIONS_$eq(new StringOps(Predef$.MODULE$.augmentString(iters)).toInt());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.err.println("Usage: LocalALS <M> <U> <F> <iters>");
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.showWarning();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running with M=", ", U=", ", F=", ", iters=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.M()), BoxesRunTime.boxToInteger((int)this.U()), BoxesRunTime.boxToInteger((int)this.F()), BoxesRunTime.boxToInteger((int)this.ITERATIONS())})));
        RealMatrix R = this.generateR();
        ObjectRef ms = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.M(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RealVector apply() {
                return LocalALS$.MODULE$.org$apache$spark$examples$LocalALS$$randomVector(LocalALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(RealVector.class))));
        ObjectRef us = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.U(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RealVector apply() {
                return LocalALS$.MODULE$.org$apache$spark$examples$LocalALS$$randomVector(LocalALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(RealVector.class))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)new Serializable(R, ms, us){
            public static final long serialVersionUID = 0L;
            public final RealMatrix R$3;
            public final ObjectRef ms$3;
            public final ObjectRef us$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iter)})));
                this.ms$3.elem = (RealVector[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.M()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final RealVector apply(int i) {
                        return LocalALS$.MODULE$.updateMovie(i, ((RealVector[])this.$outer.ms$3.elem)[i], (RealVector[])this.$outer.us$3.elem, this.$outer.R$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RealVector.class));
                this.us$3.elem = (RealVector[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.U()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final RealVector apply(int j) {
                        return LocalALS$.MODULE$.updateUser(j, ((RealVector[])this.$outer.us$3.elem)[j], (RealVector[])this.$outer.ms$3.elem, this.$outer.R$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RealVector.class));
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"RMSE = ").append((Object)BoxesRunTime.boxToDouble((double)LocalALS$.MODULE$.rmse(this.R$3, (RealVector[])this.ms$3.elem, (RealVector[])this.us$3.elem))).toString());
                Predef$.MODULE$.println();
            }
            {
                this.R$3 = R$3;
                this.ms$3 = ms$3;
                this.us$3 = us$3;
            }
        });
    }

    public RealVector org$apache$spark$examples$LocalALS$$randomVector(int n) {
        return new ArrayRealVector((double[])Array$.MODULE$.fill(n, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return package$.MODULE$.random();
            }
        }, ClassTag$.MODULE$.Double()));
    }

    private RealMatrix randomMatrix(int rows, int cols) {
        return new Array2DRowRealMatrix((double[][])Array$.MODULE$.fill(rows, cols, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return package$.MODULE$.random();
            }
        }, ClassTag$.MODULE$.Double()));
    }

    private LocalALS$() {
        MODULE$ = this;
        this.M = 0;
        this.U = 0;
        this.F = 0;
        this.ITERATIONS = 0;
        this.LAMBDA = 0.01;
    }
}

