/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaPairReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kafka.KafkaUtils;
import scala.Tuple2;

public final class JavaKafkaWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    private JavaKafkaWordCount() {
    }

    public static void main(String[] args) throws Exception {
        String[] topics;
        if (args.length < 4) {
            System.err.println("Usage: JavaKafkaWordCount <zkQuorum> <group> <topics> <numThreads>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaKafkaWordCount");
        JavaStreamingContext jssc = new JavaStreamingContext(sparkConf, new Duration(2000L));
        int numThreads = Integer.parseInt(args[3]);
        HashMap<String, Integer> topicMap = new HashMap<String, Integer>();
        for (String topic : topics = args[2].split(",")) {
            topicMap.put(topic, numThreads);
        }
        JavaPairReceiverInputDStream messages = KafkaUtils.createStream((JavaStreamingContext)jssc, (String)args[0], (String)args[1], topicMap);
        JavaDStream lines = messages.map((Function)new Function<Tuple2<String, String>, String>(){

            public String call(Tuple2<String, String> tuple2) {
                return (String)tuple2._2();
            }
        });
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterator<String> call(String x) {
                return Arrays.asList(SPACE.split(x)).iterator();
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

