/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaSparkSQLExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("Java Spark SQL basic example").config("spark.some.config.option", "some-value").getOrCreate();
        JavaSparkSQLExample.runBasicDataFrameExample(spark);
        JavaSparkSQLExample.runDatasetCreationExample(spark);
        JavaSparkSQLExample.runInferSchemaExample(spark);
        JavaSparkSQLExample.runProgrammaticSchemaExample(spark);
        spark.stop();
    }

    private static void runBasicDataFrameExample(SparkSession spark) {
        Dataset df = spark.read().json("examples/src/main/resources/people.json");
        df.show();
        df.printSchema();
        df.select("name", new String[0]).show();
        df.select(new Column[]{functions.col((String)"name"), functions.col((String)"age").plus((Object)1)}).show();
        df.filter(functions.col((String)"age").gt((Object)21)).show();
        df.groupBy("age", new String[0]).count().show();
        df.createOrReplaceTempView("people");
        Dataset sqlDF = spark.sql("SELECT * FROM people");
        sqlDF.show();
    }

    private static void runDatasetCreationExample(SparkSession spark) {
        Person person = new Person();
        person.setName("Andy");
        person.setAge(32);
        Encoder personEncoder = Encoders.bean(Person.class);
        Dataset javaBeanDS = spark.createDataset(Collections.singletonList(person), personEncoder);
        javaBeanDS.show();
        Encoder integerEncoder = Encoders.INT();
        Dataset primitiveDS = spark.createDataset(Arrays.asList(1, 2, 3), integerEncoder);
        Dataset transformedDS = primitiveDS.map((MapFunction)new MapFunction<Integer, Integer>(){

            public Integer call(Integer value) throws Exception {
                return value + 1;
            }
        }, integerEncoder);
        transformedDS.collect();
        String path = "examples/src/main/resources/people.json";
        Dataset peopleDS = spark.read().json(path).as(personEncoder);
        peopleDS.show();
    }

    private static void runInferSchemaExample(SparkSession spark) {
        JavaRDD peopleRDD = spark.read().textFile("examples/src/main/resources/people.txt").javaRDD().map((Function)new Function<String, Person>(){

            public Person call(String line) throws Exception {
                String[] parts = line.split(",");
                Person person = new Person();
                person.setName(parts[0]);
                person.setAge(Integer.parseInt(parts[1].trim()));
                return person;
            }
        });
        Dataset peopleDF = spark.createDataFrame(peopleRDD, Person.class);
        peopleDF.createOrReplaceTempView("people");
        Dataset teenagersDF = spark.sql("SELECT name FROM people WHERE age BETWEEN 13 AND 19");
        Encoder stringEncoder = Encoders.STRING();
        Dataset teenagerNamesByIndexDF = teenagersDF.map((MapFunction)new MapFunction<Row, String>(){

            public String call(Row row) throws Exception {
                return "Name: " + row.getString(0);
            }
        }, stringEncoder);
        teenagerNamesByIndexDF.show();
        Dataset teenagerNamesByFieldDF = teenagersDF.map((MapFunction)new MapFunction<Row, String>(){

            public String call(Row row) throws Exception {
                return "Name: " + (String)row.getAs("name");
            }
        }, stringEncoder);
        teenagerNamesByFieldDF.show();
    }

    private static void runProgrammaticSchemaExample(SparkSession spark) {
        JavaRDD peopleRDD = spark.sparkContext().textFile("examples/src/main/resources/people.txt", 1).toJavaRDD();
        String schemaString = "name age";
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (String fieldName : schemaString.split(" ")) {
            StructField field = DataTypes.createStructField((String)fieldName, (DataType)DataTypes.StringType, (boolean)true);
            fields.add(field);
        }
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = peopleRDD.map((Function)new Function<String, Row>(){

            public Row call(String record) throws Exception {
                String[] attributes = record.split(",");
                return RowFactory.create((Object[])new Object[]{attributes[0], attributes[1].trim()});
            }
        });
        Dataset peopleDataFrame = spark.createDataFrame(rowRDD, schema);
        peopleDataFrame.createOrReplaceTempView("people");
        Dataset results = spark.sql("SELECT name FROM people");
        Dataset namesDS = results.map((MapFunction)new MapFunction<Row, String>(){

            public String call(Row row) throws Exception {
                return "Name: " + row.getString(0);
            }
        }, Encoders.STRING());
        namesDS.show();
    }

    public static class Person
    implements Serializable {
        private String name;
        private int age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

