/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.SampledRDDs;
import org.apache.spark.examples.mllib.SampledRDDs$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class SampledRDDs$ {
    public static final SampledRDDs$ MODULE$;

    static {
        new SampledRDDs$();
    }

    public void main(String[] args) {
        SampledRDDs.Params defaultParams = new SampledRDDs.Params(SampledRDDs$Params$.MODULE$.apply$default$1());
        OptionParser<SampledRDDs.Params> parser = new OptionParser<SampledRDDs.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SampledRDDs: an example app for randomly generated and sampled RDDs."}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input path to labeled examples in LIBSVM format, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.input()}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SampledRDDs.Params apply(String x, SampledRDDs.Params c) {
                        return c.copy(x);
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.SampledRDDs \\\n        |  examples/target/scala-*/spark-examples-*.jar\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SampledRDDs.Params params) {
                SampledRDDs$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(SampledRDDs.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SampledRDDs with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        double fraction = 0.1;
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input());
        long numExamples = examples.count();
        if (numExamples == 0L) {
            throw new RuntimeException("Error: Data file had no samples to load.");
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded data with ", " examples from file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numExamples), params.input()})));
        int expectedSampleSize = (int)((double)numExamples * fraction);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sampling RDD using fraction ", ".  Expected sample size = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)fraction), BoxesRunTime.boxToInteger((int)expectedSampleSize)})));
        RDD sampledRDD = examples.sample(true, fraction, examples.sample$default$3());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  RDD.sample(): sample has ", " examples"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sampledRDD.count())})));
        LabeledPoint[] sampledArray = (LabeledPoint[])examples.takeSample(true, expectedSampleSize, examples.takeSample$default$3());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  RDD.takeSample(): sample has ", " examples"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sampledArray.length)})));
        Predef$.MODULE$.println();
        RDD keyedRDD = examples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)lp.label())), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Keyed data using label (Int) as key ==> Orig"})).s((Seq)Nil$.MODULE$));
        Map keyCounts = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        scala.collection.immutable.Map fractions = ((TraversableOnce)keyCounts.keys().map((Function1)new Serializable(fraction){
            public static final long serialVersionUID = 0L;
            private final double fraction$1;

            public final Tuple2<Object, Object> apply(int x$1) {
                return new Tuple2.mcID.sp(x$1, this.fraction$1);
            }
            {
                this.fraction$1 = fraction$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$2 = true;
        scala.collection.immutable.Map x$3 = fractions;
        long x$4 = qual$1.sampleByKey$default$3();
        RDD sampledByKeyRDD = qual$1.sampleByKey(x$2, (Map)x$3, x$4);
        Map keyCountsB = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeB = BoxesRunTime.unboxToLong((Object)keyCountsB.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sampled ", " examples using approximate stratified sampling (by label)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sizeB)}))).append((Object)" ==> Approx Sample").toString());
        PairRDDFunctions qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$5 = true;
        scala.collection.immutable.Map x$6 = fractions;
        long x$7 = qual$2.sampleByKeyExact$default$3();
        RDD sampledByKeyRDDExact = qual$2.sampleByKeyExact(x$5, (Map)x$6, x$7);
        Map keyCountsBExact = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDDExact, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeBExact = BoxesRunTime.unboxToLong((Object)keyCountsBExact.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sampled ", " examples using exact stratified sampling (by label)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sizeBExact)}))).append((Object)" ==> Exact Sample").toString());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"   \\tFractions of examples with key"})).s((Seq)Nil$.MODULE$));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key\\tOrig\\tApprox Sample\\tExact Sample"})).s((Seq)Nil$.MODULE$));
        ((IterableLike)keyCounts.keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(numExamples, keyCounts, keyCountsB, sizeB, keyCountsBExact, sizeBExact){
            public static final long serialVersionUID = 0L;
            private final long numExamples$1;
            private final Map keyCounts$1;
            private final Map keyCountsB$1;
            private final long sizeB$1;
            private final Map keyCountsBExact$1;
            private final long sizeBExact$1;

            public final void apply(int key) {
                this.apply$mcVI$sp(key);
            }

            public void apply$mcVI$sp(int key) {
                double origFrac = (double)BoxesRunTime.unboxToLong((Object)this.keyCounts$1.apply((Object)BoxesRunTime.boxToInteger((int)key))) / (double)this.numExamples$1;
                double approxFrac = this.sizeB$1 != 0L ? (double)BoxesRunTime.unboxToLong((Object)this.keyCountsB$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) / (double)this.sizeB$1 : 0.0;
                double exactFrac = this.sizeBExact$1 != 0L ? (double)BoxesRunTime.unboxToLong((Object)this.keyCountsBExact$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) / (double)this.sizeBExact$1 : 0.0;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)key), BoxesRunTime.boxToDouble((double)origFrac), BoxesRunTime.boxToDouble((double)approxFrac), BoxesRunTime.boxToDouble((double)exactFrac)})));
            }
            {
                this.numExamples$1 = numExamples$1;
                this.keyCounts$1 = keyCounts$1;
                this.keyCountsB$1 = keyCountsB$1;
                this.sizeB$1 = sizeB$1;
                this.keyCountsBExact$1 = keyCountsBExact$1;
                this.sizeBExact$1 = sizeBExact$1;
            }
        });
        sc.stop();
    }

    private SampledRDDs$() {
        MODULE$ = this;
    }
}

