/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import scala.Tuple2;

public class JavaStratifiedSamplingExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaStratifiedSamplingExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        List<Tuple2> list = Arrays.asList(new Tuple2((Object)1, (Object)Character.valueOf('a')), new Tuple2((Object)1, (Object)Character.valueOf('b')), new Tuple2((Object)2, (Object)Character.valueOf('c')), new Tuple2((Object)2, (Object)Character.valueOf('d')), new Tuple2((Object)2, (Object)Character.valueOf('e')), new Tuple2((Object)3, (Object)Character.valueOf('f')));
        JavaPairRDD data = jsc.parallelizePairs(list);
        ImmutableMap fractions = ImmutableMap.of((Object)1, (Object)0.1, (Object)2, (Object)0.6, (Object)3, (Object)0.3);
        JavaPairRDD approxSample = data.sampleByKey(false, (Map)fractions);
        JavaPairRDD exactSample = data.sampleByKeyExact(false, (Map)fractions);
        System.out.println("approxSample size is " + approxSample.collect().size());
        for (Tuple2 t : approxSample.collect()) {
            System.out.println(t._1() + " " + t._2());
        }
        System.out.println("exactSample size is " + exactSample.collect().size());
        for (Tuple2 t : exactSample.collect()) {
            System.out.println(t._1() + " " + t._2());
        }
        jsc.stop();
    }
}

