/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.LogisticRegressionExample;
import org.apache.spark.examples.ml.LogisticRegressionExample$;
import org.apache.spark.examples.ml.LogisticRegressionExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class LogisticRegressionExample$ {
    public static final LogisticRegressionExample$ MODULE$;

    static {
        new LogisticRegressionExample$();
    }

    public void main(String[] args) {
        LogisticRegressionExample.Params defaultParams = new LogisticRegressionExample.Params(LogisticRegressionExample$Params$.MODULE$.apply$default$1(), LogisticRegressionExample$Params$.MODULE$.apply$default$2(), LogisticRegressionExample$Params$.MODULE$.apply$default$3(), LogisticRegressionExample$Params$.MODULE$.apply$default$4(), LogisticRegressionExample$Params$.MODULE$.apply$default$5(), LogisticRegressionExample$Params$.MODULE$.apply$default$6(), LogisticRegressionExample$Params$.MODULE$.apply$default$7(), LogisticRegressionExample$Params$.MODULE$.apply$default$8(), LogisticRegressionExample$Params$.MODULE$.apply$default$9());
        OptionParser<LogisticRegressionExample.Params> parser = new OptionParser<LogisticRegressionExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionExample: an example Logistic Regression with Elastic-Net app."}));
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization parameter, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.regParam())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(double x, LogisticRegressionExample.Params c) {
                        double x$2 = x;
                        String x$3 = c.copy$default$1();
                        String x$4 = c.copy$default$2();
                        String x$5 = c.copy$default$3();
                        double x$6 = c.copy$default$5();
                        int x$7 = c.copy$default$6();
                        boolean x$8 = c.copy$default$7();
                        double x$9 = c.copy$default$8();
                        double x$10 = c.copy$default$9();
                        return c.copy(x$3, x$4, x$5, x$2, x$6, x$7, x$8, x$9, x$10);
                    }
                });
                this.opt("elasticNetParam", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ElasticNet mixing parameter. For alpha = 0, the penalty is an L2 penalty. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For alpha = 1, it is an L1 penalty. For 0 < alpha < 1, the penalty is a combination of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"L1 and L2, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.elasticNetParam())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(double x, LogisticRegressionExample.Params c) {
                        double x$11 = x;
                        String x$12 = c.copy$default$1();
                        String x$13 = c.copy$default$2();
                        String x$14 = c.copy$default$3();
                        double x$15 = c.copy$default$4();
                        int x$16 = c.copy$default$6();
                        boolean x$17 = c.copy$default$7();
                        double x$18 = c.copy$default$8();
                        double x$19 = c.copy$default$9();
                        return c.copy(x$12, x$13, x$14, x$15, x$11, x$16, x$17, x$18, x$19);
                    }
                });
                this.opt("maxIter", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maximum number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIter())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(int x, LogisticRegressionExample.Params c) {
                        int x$20 = x;
                        String x$21 = c.copy$default$1();
                        String x$22 = c.copy$default$2();
                        String x$23 = c.copy$default$3();
                        double x$24 = c.copy$default$4();
                        double x$25 = c.copy$default$5();
                        boolean x$26 = c.copy$default$7();
                        double x$27 = c.copy$default$8();
                        double x$28 = c.copy$default$9();
                        return c.copy(x$21, x$22, x$23, x$24, x$25, x$20, x$26, x$27, x$28);
                    }
                });
                this.opt("fitIntercept", Read$.MODULE$.booleanRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"whether to fit an intercept term, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)defaultParams$1.fitIntercept())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(boolean x, LogisticRegressionExample.Params c) {
                        boolean x$29 = x;
                        String x$30 = c.copy$default$1();
                        String x$31 = c.copy$default$2();
                        String x$32 = c.copy$default$3();
                        double x$33 = c.copy$default$4();
                        double x$34 = c.copy$default$5();
                        int x$35 = c.copy$default$6();
                        double x$36 = c.copy$default$8();
                        double x$37 = c.copy$default$9();
                        return c.copy(x$30, x$31, x$32, x$33, x$34, x$35, x$29, x$36, x$37);
                    }
                });
                this.opt("tol", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the convergence tolerance of iterations, Smaller value will lead "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to higher accuracy with the cost of more iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.tol())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(double x, LogisticRegressionExample.Params c) {
                        double x$38 = x;
                        String x$39 = c.copy$default$1();
                        String x$40 = c.copy$default$2();
                        String x$41 = c.copy$default$3();
                        double x$42 = c.copy$default$4();
                        double x$43 = c.copy$default$5();
                        int x$44 = c.copy$default$6();
                        boolean x$45 = c.copy$default$7();
                        double x$46 = c.copy$default$9();
                        return c.copy(x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$38, x$46);
                    }
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing. If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(double x, LogisticRegressionExample.Params c) {
                        double x$47 = x;
                        String x$48 = c.copy$default$1();
                        String x$49 = c.copy$default$2();
                        String x$50 = c.copy$default$3();
                        double x$51 = c.copy$default$4();
                        double x$52 = c.copy$default$5();
                        int x$53 = c.copy$default$6();
                        boolean x$54 = c.copy$default$7();
                        double x$55 = c.copy$default$8();
                        return c.copy(x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$47);
                    }
                });
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to test dataset. If given, option fracTest is ignored."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.testInput()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(String x, LogisticRegressionExample.Params c) {
                        String x$56 = x;
                        String x$57 = c.copy$default$1();
                        String x$58 = c.copy$default$3();
                        double x$59 = c.copy$default$4();
                        double x$60 = c.copy$default$5();
                        int x$61 = c.copy$default$6();
                        boolean x$62 = c.copy$default$7();
                        double x$63 = c.copy$default$8();
                        double x$64 = c.copy$default$9();
                        return c.copy(x$57, x$56, x$58, x$59, x$60, x$61, x$62, x$63, x$64);
                    }
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(String x, LogisticRegressionExample.Params c) {
                        String x$65 = x;
                        String x$66 = c.copy$default$1();
                        String x$67 = c.copy$default$2();
                        double x$68 = c.copy$default$4();
                        double x$69 = c.copy$default$5();
                        int x$70 = c.copy$default$6();
                        boolean x$71 = c.copy$default$7();
                        double x$72 = c.copy$default$8();
                        double x$73 = c.copy$default$9();
                        return c.copy(x$66, x$67, x$65, x$68, x$69, x$70, x$71, x$72, x$73);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogisticRegressionExample.Params apply(String x, LogisticRegressionExample.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9());
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(LogisticRegressionExample.Params params) {
                        return params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())}))) : this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LogisticRegressionExample.Params params) {
                LogisticRegressionExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(LogisticRegressionExample.Params params) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}))).getOrCreate();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionExample with parameters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        Tuple2<Dataset<Row>, Dataset<Row>> tuple2 = DecisionTreeExample$.MODULE$.loadDatasets(params.input(), params.dataFormat(), params.testInput(), "classification", params.fracTest());
        if (tuple2 != null) {
            Dataset training = (Dataset)tuple2._1();
            Dataset test = (Dataset)tuple2._2();
            if (training != null) {
                Dataset dataset = training;
                if (test != null) {
                    Tuple2 tuple22;
                    Dataset dataset2 = test;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataset, (Object)dataset2);
                    Dataset training2 = (Dataset)tuple23._1();
                    Dataset test2 = (Dataset)tuple23._2();
                    ArrayBuffer stages = new ArrayBuffer();
                    StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel");
                    stages.$plus$eq((Object)labelIndexer);
                    LogisticRegression lor = ((LogisticRegression)new LogisticRegression().setFeaturesCol("features").setLabelCol("indexedLabel")).setRegParam(params.regParam()).setElasticNetParam(params.elasticNetParam()).setMaxIter(params.maxIter()).setTol(params.tol()).setFitIntercept(params.fitIntercept());
                    stages.$plus$eq((Object)lor);
                    Pipeline pipeline = new Pipeline().setStages((PipelineStage[])stages.toArray(ClassTag$.MODULE$.apply(PipelineStage.class)));
                    long startTime = System.nanoTime();
                    PipelineModel pipelineModel = pipeline.fit(training2);
                    double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                    LogisticRegressionModel lorModel = (LogisticRegressionModel)Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages()).last();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weights: ", " Intercept: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lorModel.coefficients(), BoxesRunTime.boxToDouble((double)lorModel.intercept())})));
                    Predef$.MODULE$.println((Object)"Training data results:");
                    DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)training2, "indexedLabel");
                    Predef$.MODULE$.println((Object)"Test data results:");
                    DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)test2, "indexedLabel");
                    spark.stop();
                    return;
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private LogisticRegressionExample$() {
        MODULE$ = this;
    }
}

