/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.VectorSlicer;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class JavaVectorSlicerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaVectorSlicerExample").getOrCreate();
        Attribute[] attrs = new Attribute[]{NumericAttribute.defaultAttr().withName("f1"), NumericAttribute.defaultAttr().withName("f2"), NumericAttribute.defaultAttr().withName("f3")};
        AttributeGroup group = new AttributeGroup("userFeatures", attrs);
        ArrayList data = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{Vectors.sparse((int)3, (int[])new int[]{0, 1}, (double[])new double[]{-2.0, 2.3})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3, 0.0})})});
        Dataset dataset = spark.createDataFrame((List)data, new StructType().add(group.toStructField()));
        VectorSlicer vectorSlicer = new VectorSlicer().setInputCol("userFeatures").setOutputCol("features");
        vectorSlicer.setIndices(new int[]{1}).setNames(new String[]{"f3"});
        Dataset output = vectorSlicer.transform(dataset);
        System.out.println(output.select("userFeatures", new String[]{"features"}).first());
        spark.stop();
    }
}

