/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaPolynomialExpansionExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaPolynomialExpansionExample").getOrCreate();
        PolynomialExpansion polyExpansion = ((PolynomialExpansion)((PolynomialExpansion)new PolynomialExpansion().setInputCol("features")).setOutputCol("polyFeatures")).setDegree(3);
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{0.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.6, (double[])new double[]{-1.1})}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        Dataset polyDF = polyExpansion.transform(df);
        List rows = polyDF.select("polyFeatures", new String[0]).takeAsList(3);
        for (Row r : rows) {
            System.out.println(r.get(0));
        }
        spark.stop();
    }
}

