/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import scala.Tuple2;

public final class JavaQueueStream {
    private JavaQueueStream() {
    }

    public static void main(String[] args) throws Exception {
        int i;
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaQueueStream");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, new Duration(1000L));
        LinkedList<JavaRDD> rddQueue = new LinkedList<JavaRDD>();
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < 1000; ++i) {
            list.add(i);
        }
        for (i = 0; i < 30; ++i) {
            rddQueue.add(ssc.sparkContext().parallelize((List)list));
        }
        JavaDStream inputStream = ssc.queueStream(rddQueue);
        JavaPairDStream mappedStream = inputStream.mapToPair((PairFunction)new PairFunction<Integer, Integer, Integer>(){

            public Tuple2<Integer, Integer> call(Integer i) {
                return new Tuple2((Object)(i % 10), (Object)1);
            }
        });
        JavaPairDStream reducedStream = mappedStream.reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        reducedStream.print();
        ssc.start();
        ssc.awaitTermination();
    }
}

