/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import org.apache.spark.examples.sql.SQLDataSourceExample$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.RichInt$;

public final class SQLDataSourceExample$ {
    public static final SQLDataSourceExample$ MODULE$;

    static {
        new SQLDataSourceExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Spark SQL data sources example").config("spark.some.config.option", "some-value").getOrCreate();
        this.runBasicDataSourceExample(spark);
        this.runBasicParquetExample(spark);
        this.runParquetSchemaMergingExample(spark);
        this.runJsonDatasetExample(spark);
        this.runJdbcDatasetExample(spark);
        spark.stop();
    }

    private void runBasicDataSourceExample(SparkSession spark) {
        Dataset usersDF = spark.read().load("examples/src/main/resources/users.parquet");
        usersDF.select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"favorite_color"})).write().save("namesAndFavColors.parquet");
        Dataset peopleDF = spark.read().format("json").load("examples/src/main/resources/people.json");
        peopleDF.select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"age"})).write().format("parquet").save("namesAndAges.parquet");
        Dataset sqlDF = spark.sql("SELECT * FROM parquet.`examples/src/main/resources/users.parquet`");
    }

    private void runBasicParquetExample(SparkSession spark) {
        Dataset peopleDF = spark.read().json("examples/src/main/resources/people.json");
        peopleDF.write().parquet("people.parquet");
        Dataset parquetFileDF = spark.read().parquet("people.parquet");
        parquetFileDF.createOrReplaceTempView("parquetFile");
        Dataset namesDF = spark.sql("SELECT name FROM parquetFile WHERE age BETWEEN 13 AND 19");
        namesDF.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row attributes) {
                return new StringBuilder().append((Object)"Name: ").append(attributes.apply(0)).toString();
            }
        }, spark.implicits().newStringEncoder()).show();
    }

    private void runParquetSchemaMergingExample(SparkSession spark) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator3$1() {
            }
        }
        Dataset squaresDF = spark.implicits().rddToDatasetHolder(spark.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5), spark.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int i) {
                return new Tuple2.mcII.sp(i, i * i);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator3$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "square"}));
        squaresDF.write().parquet("data/test_table/key=1");
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1() {
            }
        }
        Dataset cubesDF = spark.implicits().rddToDatasetHolder(spark.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10), spark.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int i) {
                return new Tuple2.mcII.sp(i, i * i * i);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "cube"}));
        cubesDF.write().parquet("data/test_table/key=2");
        Dataset mergedDF = spark.read().option("mergeSchema", "true").parquet("data/test_table");
        mergedDF.printSchema();
    }

    private void runJsonDatasetExample(SparkSession spark) {
        String path = "examples/src/main/resources/people.json";
        Dataset peopleDF = spark.read().json(path);
        peopleDF.printSchema();
        peopleDF.createOrReplaceTempView("people");
        Dataset teenagerNamesDF = spark.sql("SELECT name FROM people WHERE age BETWEEN 13 AND 19");
        teenagerNamesDF.show();
        String string = "{\"name\":\"Yin\",\"address\":{\"city\":\"Columbus\",\"state\":\"Ohio\"}}";
        RDD otherPeopleRDD = spark.sparkContext().makeRDD((Seq)Nil$.MODULE$.$colon$colon((Object)string), spark.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.apply(String.class));
        Dataset otherPeople = spark.read().json(otherPeopleRDD);
        otherPeople.show();
    }

    private void runJdbcDatasetExample(SparkSession spark) {
        Dataset dataset = spark.read().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").load();
    }

    private SQLDataSourceExample$() {
        MODULE$ = this;
    }
}

