/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.LinkedList;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;

public class JavaSVDExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SVD Example");
        SparkContext sc = new SparkContext(conf);
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)sc);
        double[][] array = new double[][]{{1.12, 2.05, 3.12}, {5.56, 6.28, 8.94}, {10.2, 8.0, 20.5}};
        LinkedList<Vector> rowsList = new LinkedList<Vector>();
        for (int i = 0; i < array.length; ++i) {
            Vector currentRow = Vectors.dense((double[])array[i]);
            rowsList.add(currentRow);
        }
        JavaRDD rows = jsc.parallelize(rowsList);
        RowMatrix mat = new RowMatrix(rows.rdd());
        SingularValueDecomposition svd = mat.computeSVD(3, true, 1.0E-9);
        RowMatrix U = (RowMatrix)svd.U();
        Vector s = svd.s();
        Matrix V = (Matrix)svd.V();
        Vector[] collectPartitions = (Vector[])U.rows().collect();
        System.out.println("U factor is:");
        for (Vector vector : collectPartitions) {
            System.out.println("\t" + vector);
        }
        System.out.println("Singular values are: " + s);
        System.out.println("V factor is:\n" + V);
        jsc.stop();
    }
}

