/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaRankingMetricsExample {
    public static void main(String[] args) {
        Integer[] kVector;
        SparkConf conf = new SparkConf().setAppName("Java Ranking Metrics Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        String path = "data/mllib/sample_movielens_data.txt";
        JavaRDD data = sc.textFile(path);
        JavaRDD ratings = data.map((Function)new Function<String, Rating>(){

            public Rating call(String line) {
                String[] parts = line.split("::");
                return new Rating(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Double.parseDouble(parts[2]) - 2.5);
            }
        });
        ratings.cache();
        MatrixFactorizationModel model = ALS.train((RDD)JavaRDD.toRDD((JavaRDD)ratings), (int)10, (int)10, (double)0.01);
        JavaRDD userRecs = model.recommendProductsForUsers(10).toJavaRDD();
        JavaRDD userRecsScaled = userRecs.map((Function)new Function<Tuple2<Object, Rating[]>, Tuple2<Object, Rating[]>>(){

            public Tuple2<Object, Rating[]> call(Tuple2<Object, Rating[]> t) {
                Rating[] scaledRatings = new Rating[((Rating[])t._2()).length];
                for (int i = 0; i < scaledRatings.length; ++i) {
                    double newRating = Math.max(Math.min(((Rating[])t._2())[i].rating(), 1.0), 0.0);
                    scaledRatings[i] = new Rating(((Rating[])t._2())[i].user(), ((Rating[])t._2())[i].product(), newRating);
                }
                return new Tuple2(t._1(), (Object)scaledRatings);
            }
        });
        JavaPairRDD userRecommended = JavaPairRDD.fromJavaRDD((JavaRDD)userRecsScaled);
        JavaRDD binarizedRatings = ratings.map((Function)new Function<Rating, Rating>(){

            public Rating call(Rating r) {
                double binaryRating = r.rating() > 0.0 ? 1.0 : 0.0;
                return new Rating(r.user(), r.product(), binaryRating);
            }
        });
        JavaPairRDD userMovies = binarizedRatings.groupBy((Function)new Function<Rating, Object>(){

            public Object call(Rating r) {
                return r.user();
            }
        });
        JavaPairRDD userMoviesList = userMovies.mapValues((Function)new Function<Iterable<Rating>, List<Integer>>(){

            public List<Integer> call(Iterable<Rating> docs) {
                ArrayList<Integer> products = new ArrayList<Integer>();
                for (Rating r : docs) {
                    if (!(r.rating() > 0.0)) continue;
                    products.add(r.product());
                }
                return products;
            }
        });
        JavaPairRDD userRecommendedList = userRecommended.mapValues((Function)new Function<Rating[], List<Integer>>(){

            public List<Integer> call(Rating[] docs) {
                ArrayList<Integer> products = new ArrayList<Integer>();
                for (Rating r : docs) {
                    products.add(r.product());
                }
                return products;
            }
        });
        JavaRDD relevantDocs = userMoviesList.join(userRecommendedList).values();
        RankingMetrics metrics = RankingMetrics.of((JavaRDD)relevantDocs);
        for (Integer k : kVector = new Integer[]{1, 3, 5}) {
            System.out.format("Precision at %d = %f\n", k, metrics.precisionAt(k.intValue()));
            System.out.format("NDCG at %d = %f\n", k, metrics.ndcgAt(k.intValue()));
        }
        System.out.format("Mean average precision = %f\n", metrics.meanAveragePrecision());
        JavaRDD userProducts = ratings.map((Function)new Function<Rating, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(Rating r) {
                return new Tuple2((Object)r.user(), (Object)r.product());
            }
        });
        JavaPairRDD predictions = JavaPairRDD.fromJavaRDD((JavaRDD)model.predict(JavaRDD.toRDD((JavaRDD)userProducts)).toJavaRDD().map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Object>>(){

            public Tuple2<Tuple2<Integer, Integer>, Object> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        }));
        JavaRDD ratesAndPreds = JavaPairRDD.fromJavaRDD((JavaRDD)ratings.map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Object>>(){

            public Tuple2<Tuple2<Integer, Integer>, Object> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        })).join(predictions).values();
        RegressionMetrics regressionMetrics = new RegressionMetrics(ratesAndPreds.rdd());
        System.out.format("RMSE = %f\n", regressionMetrics.rootMeanSquaredError());
        System.out.format("R-squared = %f\n", regressionMetrics.r2());
        sc.stop();
    }
}

