/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaMulticlassClassificationMetricsExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Multi class Classification Metrics Example");
        SparkContext sc = new SparkContext(conf);
        String path = "data/mllib/sample_multiclass_classification_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc, (String)path).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        JavaRDD training = splits[0].cache();
        JavaRDD test = splits[1];
        final LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(3).run(training.rdd());
        JavaRDD predictionAndLabels = test.map((Function)new Function<LabeledPoint, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(LabeledPoint p) {
                Double prediction = model.predict(p.features());
                return new Tuple2((Object)prediction, (Object)p.label());
            }
        });
        MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels.rdd());
        Matrix confusion = metrics.confusionMatrix();
        System.out.println("Confusion matrix: \n" + confusion);
        System.out.println("Accuracy = " + metrics.accuracy());
        for (int i = 0; i < metrics.labels().length; ++i) {
            System.out.format("Class %f precision = %f\n", metrics.labels()[i], metrics.precision(metrics.labels()[i]));
            System.out.format("Class %f recall = %f\n", metrics.labels()[i], metrics.recall(metrics.labels()[i]));
            System.out.format("Class %f F1 score = %f\n", metrics.labels()[i], metrics.fMeasure(metrics.labels()[i]));
        }
        System.out.format("Weighted precision = %f\n", metrics.weightedPrecision());
        System.out.format("Weighted recall = %f\n", metrics.weightedRecall());
        System.out.format("Weighted F1 score = %f\n", metrics.weightedFMeasure());
        System.out.format("Weighted false positive rate = %f\n", metrics.weightedFalsePositiveRate());
        model.save(sc, "target/tmp/LogisticRegressionModel");
        LogisticRegressionModel sameModel = LogisticRegressionModel.load((SparkContext)sc, (String)"target/tmp/LogisticRegressionModel");
    }
}

