/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RegressionMetricsExample$ {
    public static final RegressionMetricsExample$ MODULE$;

    static {
        new RegressionMetricsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("RegressionMetricsExample").getOrCreate();
        RDD data = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt").rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row row) {
                return new LabeledPoint(row.getDouble(0), (Vector)row.get(1));
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        int numIterations = 100;
        LinearRegressionModel model = LinearRegressionWithSGD$.MODULE$.train(data, numIterations);
        RDD valuesAndPreds = data.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final LinearRegressionModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint point) {
                double prediction = this.model$1.predict(point.features());
                return new Tuple2.mcDD.sp(prediction, point.label());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics metrics = new RegressionMetrics(valuesAndPreds);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MSE = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.meanSquaredError())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RMSE = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.rootMeanSquaredError())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R-squared = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.r2())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAE = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.meanAbsoluteError())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Explained variance = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.explainedVariance())})));
        spark.stop();
    }

    private RegressionMetricsExample$() {
        MODULE$ = this;
    }
}

