/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaRandomForestRegressionExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaRandomForestRegressionExample");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        String datapath = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)datapath).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.7, 0.3});
        JavaRDD trainingData = splits[0];
        JavaRDD testData = splits[1];
        HashMap categoricalFeaturesInfo = new HashMap();
        Integer numTrees = 3;
        String featureSubsetStrategy = "auto";
        String impurity = "variance";
        Integer maxDepth = 4;
        Integer maxBins = 32;
        Integer seed = 12345;
        final RandomForestModel model = RandomForest.trainRegressor((JavaRDD)trainingData, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        JavaPairRDD predictionAndLabel = testData.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        Double testMSE = (Double)predictionAndLabel.map((Function)new Function<Tuple2<Double, Double>, Double>(){

            public Double call(Tuple2<Double, Double> pl) {
                Double diff = (Double)pl._1() - (Double)pl._2();
                return diff * diff;
            }
        }).reduce((Function2)new Function2<Double, Double, Double>(){

            public Double call(Double a, Double b) {
                return a + b;
            }
        }) / (double)testData.count();
        System.out.println("Test Mean Squared Error: " + testMSE);
        System.out.println("Learned regression forest model:\n" + model.toDebugString());
        model.save(jsc.sc(), "target/tmp/myRandomForestRegressionModel");
        RandomForestModel sameModel = RandomForestModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myRandomForestRegressionModel");
        jsc.stop();
    }
}

