/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.stat.Statistics;
import org.apache.spark.rdd.RDD;

public class JavaCorrelationsExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaCorrelationsExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        JavaDoubleRDD seriesX = jsc.parallelizeDoubles(Arrays.asList(1.0, 2.0, 3.0, 3.0, 5.0));
        JavaDoubleRDD seriesY = jsc.parallelizeDoubles(Arrays.asList(11.0, 22.0, 33.0, 33.0, 555.0));
        Double correlation = Statistics.corr((RDD)seriesX.srdd(), (RDD)seriesY.srdd(), (String)"pearson");
        System.out.println("Correlation is: " + correlation);
        JavaRDD data = jsc.parallelize(Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{10.0, 100.0}), Vectors.dense((double)2.0, (double[])new double[]{20.0, 200.0}), Vectors.dense((double)5.0, (double[])new double[]{33.0, 366.0})));
        Matrix correlMatrix = Statistics.corr((RDD)data.rdd(), (String)"pearson");
        System.out.println(correlMatrix.toString());
        jsc.stop();
    }
}

