/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DenseGaussianMixture$ {
    public static final DenseGaussianMixture$ MODULE$;

    static {
        new DenseGaussianMixture$();
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"usage: DenseGmmEM <input file> <k> <convergenceTol> [maxIterations]");
        } else {
            int maxIterations = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 100;
            this.run(args[0], new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble(), maxIterations);
        }
    }

    private void run(String inputFile, int k, double convergenceTol, int maxIterations) {
        SparkConf conf = new SparkConf().setAppName("Gaussian Mixture Model EM example");
        SparkContext ctx = new SparkContext(conf);
        RDD data = ctx.textFile(inputFile, ctx.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String line) {
                return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line.trim())).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        GaussianMixtureModel clusters = new GaussianMixture().setK(k).setConvergenceTol(convergenceTol).setMaxIterations(maxIterations).run(data);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), clusters.k()).foreach$mVc$sp((Function1)new Serializable(clusters){
            public static final long serialVersionUID = 0L;
            private final GaussianMixtureModel clusters$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("weight=%f\nmu=%s\nsigma=\n%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.clusters$1.weights()[i]), this.clusters$1.gaussians()[i].mu(), this.clusters$1.gaussians()[i].sigma()})));
            }
            {
                this.clusters$1 = clusters$1;
            }
        });
        Predef$.MODULE$.println((Object)"The membership value of each vector to all mixture components (first <= 100):");
        RDD membership = clusters.predictSoft(data);
        Predef$.MODULE$.refArrayOps((Object[])membership.take(100)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(double[] x) {
                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" ").append((Object)Predef$.MODULE$.doubleArrayOps(x).mkString(",")).toString());
            }
        });
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Cluster labels (first <= 100):");
        RDD clusterLabels = clusters.predict(data);
        Predef$.MODULE$.intArrayOps((int[])clusterLabels.take(100)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(int x) {
                this.apply$mcVI$sp(x);
            }

            public void apply$mcVI$sp(int x) {
                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)x)).toString());
            }
        });
        Predef$.MODULE$.println();
    }

    private DenseGaussianMixture$() {
        MODULE$ = this;
    }
}

