/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;

public final class ModelSelectionViaTrainValidationSplitExample$ {
    public static final ModelSelectionViaTrainValidationSplitExample$ MODULE$;

    static {
        new ModelSelectionViaTrainValidationSplitExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("ModelSelectionViaTrainValidationSplitExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        Dataset[] datasetArray = data.randomSplit(new double[]{0.9, 0.1}, 12345L);
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset training = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset test = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            Dataset training2 = (Dataset)tuple22._1();
            Dataset test2 = (Dataset)tuple22._2();
            LinearRegression lr = new LinearRegression();
            ParamMap[] paramGrid = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.01}).addGrid(lr.fitIntercept()).addGrid(lr.elasticNetParam(), new double[]{0.0, 0.5, 1.0}).build();
            TrainValidationSplit trainValidationSplit = new TrainValidationSplit().setEstimator((Estimator)lr).setEvaluator((Evaluator)new RegressionEvaluator()).setEstimatorParamMaps(paramGrid).setTrainRatio(0.8);
            TrainValidationSplitModel model = trainValidationSplit.fit(training2);
            model.transform(test2).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "prediction"})).show();
            spark.stop();
            return;
        }
        throw new MatchError((Object)datasetArray);
    }

    private ModelSelectionViaTrainValidationSplitExample$() {
        MODULE$ = this;
    }
}

