/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Word2Vec;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaWord2VecExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaWord2VecExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("Hi I heard about Spark".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("I wish Java could use case classes".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("Logistic regression models are neat".split(" "))}));
        StructType schema = new StructType(new StructField[]{new StructField("text", (DataType)new ArrayType(DataTypes.StringType, true), false, Metadata.empty())});
        Dataset documentDF = spark.createDataFrame(data, schema);
        Word2Vec word2Vec = new Word2Vec().setInputCol("text").setOutputCol("result").setVectorSize(3).setMinCount(0);
        Word2VecModel model = word2Vec.fit(documentDF);
        Dataset result = model.transform(documentDF);
        for (Row r : result.select("result", new String[0]).takeAsList(3)) {
            System.out.println(r);
        }
        spark.stop();
    }
}

