/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.QuantileDiscretizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaQuantileDiscretizerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaQuantileDiscretizerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, 18.0}), RowFactory.create((Object[])new Object[]{1, 19.0}), RowFactory.create((Object[])new Object[]{2, 8.0}), RowFactory.create((Object[])new Object[]{3, 5.0}), RowFactory.create((Object[])new Object[]{4, 2.2}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("hour", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        df = df.repartition(1);
        QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("hour").setOutputCol("result").setNumBuckets(3);
        Dataset result = discretizer.fit(df).transform(df);
        result.show();
        spark.stop();
    }
}

