/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DenseKMeans;
import org.apache.spark.examples.mllib.DenseKMeans$InitializationMode$;
import org.apache.spark.examples.mllib.DenseKMeans$Params$;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class DenseKMeans$ {
    public static final DenseKMeans$ MODULE$;

    static {
        new DenseKMeans$();
    }

    public void main(String[] args) {
        DenseKMeans.Params defaultParams = new DenseKMeans.Params(DenseKMeans$Params$.MODULE$.apply$default$1(), DenseKMeans$Params$.MODULE$.apply$default$2(), DenseKMeans$Params$.MODULE$.apply$default$3(), DenseKMeans$Params$.MODULE$.apply$default$4());
        OptionParser<DenseKMeans.Params> parser = new OptionParser<DenseKMeans.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DenseKMeans: an example k-means app for dense data."}));
                this.opt('k', "k", Read$.MODULE$.intRead()).required().text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of clusters, required"})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseKMeans.Params apply(int x, DenseKMeans.Params c) {
                        int x$2 = x;
                        String x$3 = c.copy$default$1();
                        int x$4 = c.copy$default$3();
                        Enumeration.Value x$5 = c.copy$default$4();
                        return c.copy(x$3, x$2, x$4, x$5);
                    }
                });
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numIterations())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseKMeans.Params apply(int x, DenseKMeans.Params c) {
                        int x$6 = x;
                        String x$7 = c.copy$default$1();
                        int x$8 = c.copy$default$2();
                        Enumeration.Value x$9 = c.copy$default$4();
                        return c.copy(x$7, x$8, x$6, x$9);
                    }
                });
                this.opt("initMode", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initialization mode (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DenseKMeans$InitializationMode$.MODULE$.values().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.initializationMode()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseKMeans.Params apply(String x, DenseKMeans.Params c) {
                        Enumeration.Value x$10 = DenseKMeans$InitializationMode$.MODULE$.withName(x);
                        String x$11 = c.copy$default$1();
                        int x$12 = c.copy$default$2();
                        int x$13 = c.copy$default$3();
                        return c.copy(x$11, x$12, x$13, x$10);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to examples").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseKMeans.Params apply(String x, DenseKMeans.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4());
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(DenseKMeans.Params params) {
                DenseKMeans$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(DenseKMeans.Params params) {
        Enumeration.Value value;
        block4: {
            String string;
            RDD examples;
            SparkContext sc;
            block3: {
                block2: {
                    SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DenseKMeans with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                    sc = new SparkContext(conf);
                    Logger.getRootLogger().setLevel(Level.WARN);
                    examples = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Vector apply(String line) {
                            return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' ')).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(String x$1) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                        }
                    }, ClassTag$.MODULE$.apply(Vector.class)).cache();
                    long numExamples = examples.count();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numExamples = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numExamples)})));
                    value = params.initializationMode();
                    Enumeration.Value value2 = DenseKMeans$InitializationMode$.MODULE$.Random();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    string = KMeans$.MODULE$.RANDOM();
                    break block3;
                }
                Enumeration.Value value4 = DenseKMeans$InitializationMode$.MODULE$.Parallel();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                string = KMeans$.MODULE$.K_MEANS_PARALLEL();
            }
            String initMode = string;
            KMeansModel model = new KMeans().setInitializationMode(initMode).setK(params.k()).setMaxIterations(params.numIterations()).run(examples);
            double cost = model.computeCost(examples);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total cost = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)cost)})));
            sc.stop();
            return;
        }
        throw new MatchError((Object)value);
    }

    private DenseKMeans$() {
        MODULE$ = this;
    }
}

