/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.BinaryClassification;
import org.apache.spark.examples.mllib.BinaryClassification$Algorithm$;
import org.apache.spark.examples.mllib.BinaryClassification$Params$;
import org.apache.spark.examples.mllib.BinaryClassification$RegType$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class BinaryClassification$ {
    public static final BinaryClassification$ MODULE$;

    static {
        new BinaryClassification$();
    }

    public void main(String[] args) {
        BinaryClassification.Params defaultParams = new BinaryClassification.Params(BinaryClassification$Params$.MODULE$.apply$default$1(), BinaryClassification$Params$.MODULE$.apply$default$2(), BinaryClassification$Params$.MODULE$.apply$default$3(), BinaryClassification$Params$.MODULE$.apply$default$4(), BinaryClassification$Params$.MODULE$.apply$default$5(), BinaryClassification$Params$.MODULE$.apply$default$6());
        OptionParser<BinaryClassification.Params> parser = new OptionParser<BinaryClassification.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BinaryClassification: an example app for binary classification."}));
                this.opt("numIterations", Read$.MODULE$.intRead()).text("number of iterations").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryClassification.Params apply(int x, BinaryClassification.Params c) {
                        int x$3 = x;
                        String x$4 = c.copy$default$1();
                        double x$5 = c.copy$default$3();
                        Enumeration.Value x$6 = c.copy$default$4();
                        Enumeration.Value x$7 = c.copy$default$5();
                        double x$8 = c.copy$default$6();
                        return c.copy(x$4, x$3, x$5, x$6, x$7, x$8);
                    }
                });
                this.opt("stepSize", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)"initial step size (ignored by logistic regression), ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.stepSize())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryClassification.Params apply(double x, BinaryClassification.Params c) {
                        double x$9 = x;
                        String x$10 = c.copy$default$1();
                        int x$11 = c.copy$default$2();
                        Enumeration.Value x$12 = c.copy$default$4();
                        Enumeration.Value x$13 = c.copy$default$5();
                        double x$14 = c.copy$default$6();
                        return c.copy(x$10, x$11, x$9, x$12, x$13, x$14);
                    }
                });
                this.opt("algorithm", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"algorithm (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinaryClassification$Algorithm$.MODULE$.values().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.algorithm()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryClassification.Params apply(String x, BinaryClassification.Params c) {
                        Enumeration.Value x$15 = BinaryClassification$Algorithm$.MODULE$.withName(x);
                        String x$16 = c.copy$default$1();
                        int x$17 = c.copy$default$2();
                        double x$18 = c.copy$default$3();
                        Enumeration.Value x$19 = c.copy$default$5();
                        double x$20 = c.copy$default$6();
                        return c.copy(x$16, x$17, x$18, x$15, x$19, x$20);
                    }
                });
                this.opt("regType", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization type (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinaryClassification$RegType$.MODULE$.values().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.regType()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryClassification.Params apply(String x, BinaryClassification.Params c) {
                        Enumeration.Value x$21 = BinaryClassification$RegType$.MODULE$.withName(x);
                        String x$22 = c.copy$default$1();
                        int x$23 = c.copy$default$2();
                        double x$24 = c.copy$default$3();
                        Enumeration.Value x$25 = c.copy$default$4();
                        double x$26 = c.copy$default$6();
                        return c.copy(x$22, x$23, x$24, x$25, x$21, x$26);
                    }
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization parameter, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.regParam())})));
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to labeled examples in LIBSVM format").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryClassification.Params apply(String x, BinaryClassification.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6());
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.BinaryClassification \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  --algorithm LR --regType L2 --regParam 1.0 \\\n          |  data/mllib/sample_binary_classification_data.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(BinaryClassification.Params params) {
                BinaryClassification$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(BinaryClassification.Params params) {
        Enumeration.Value value;
        block4: {
            Enumeration.Value value2;
            block7: {
                LogisticRegressionModel logisticRegressionModel;
                RDD test;
                SparkContext sc;
                block6: {
                    L1Updater updater;
                    RDD training;
                    block5: {
                        L1Updater l1Updater;
                        block3: {
                            block2: {
                                SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BinaryClassification with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                                sc = new SparkContext(conf);
                                Logger.getRootLogger().setLevel(Level.WARN);
                                RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
                                RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
                                training = splits[0].cache();
                                test = splits[1].cache();
                                long numTraining = training.count();
                                long numTest = test.count();
                                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training: ", ", test: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
                                examples.unpersist(false);
                                value = params.regType();
                                Enumeration.Value value3 = BinaryClassification$RegType$.MODULE$.L1();
                                Enumeration.Value value4 = value;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                                l1Updater = new L1Updater();
                                break block3;
                            }
                            Enumeration.Value value5 = BinaryClassification$RegType$.MODULE$.L2();
                            Enumeration.Value value6 = value;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                            l1Updater = new SquaredL2Updater();
                        }
                        updater = l1Updater;
                        value2 = params.algorithm();
                        Enumeration.Value value7 = BinaryClassification$Algorithm$.MODULE$.LR();
                        Enumeration.Value value8 = value2;
                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block5;
                        LogisticRegressionWithLBFGS algorithm = new LogisticRegressionWithLBFGS();
                        algorithm.optimizer().setNumIterations(params.numIterations()).setUpdater((Updater)updater).setRegParam(params.regParam());
                        logisticRegressionModel = ((LogisticRegressionModel)algorithm.run(training)).clearThreshold();
                        break block6;
                    }
                    Enumeration.Value value9 = BinaryClassification$Algorithm$.MODULE$.SVM();
                    Enumeration.Value value10 = value2;
                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block7;
                    SVMWithSGD algorithm = new SVMWithSGD();
                    algorithm.optimizer().setNumIterations(params.numIterations()).setStepSize(params.stepSize()).setUpdater((Updater)updater).setRegParam(params.regParam());
                    logisticRegressionModel = ((SVMModel)algorithm.run(training)).clearThreshold();
                }
                LogisticRegressionModel model = logisticRegressionModel;
                RDD prediction = model.predict(test.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)));
                RDD predictionAndLabel = prediction.zip(test.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(LabeledPoint x$2) {
                        return x$2.label();
                    }
                }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
                BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabel);
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test areaUnderPR = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.areaUnderPR())})));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test areaUnderROC = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.areaUnderROC())})));
                sc.stop();
                return;
            }
            throw new MatchError((Object)value2);
        }
        throw new MatchError((Object)value);
    }

    private BinaryClassification$() {
        MODULE$ = this;
    }
}

