/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MultilayerPerceptronClassifierExample$ {
    public static final MultilayerPerceptronClassifierExample$ MODULE$;

    static {
        new MultilayerPerceptronClassifierExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("MultilayerPerceptronClassifierExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        DataFrame data = sqlContext.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        DataFrame[] splits = data.randomSplit(new double[]{0.6, 0.4}, 1234L);
        DataFrame train = splits[0];
        DataFrame test = splits[1];
        int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 4, 3}), ClassTag$.MODULE$.Int());
        MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(100);
        MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(train);
        DataFrame result = model.transform(test);
        DataFrame predictionAndLabels = result.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("precision");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Precision:").append((Object)BoxesRunTime.boxToDouble((double)evaluator.evaluate(predictionAndLabels))).toString());
        sc.stop();
    }

    private MultilayerPerceptronClassifierExample$() {
        MODULE$ = this;
    }
}

