/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.VectorSlicer;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;

public class JavaVectorSlicerExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaVectorSlicerExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        Attribute[] attrs = new Attribute[]{NumericAttribute.defaultAttr().withName("f1"), NumericAttribute.defaultAttr().withName("f2"), NumericAttribute.defaultAttr().withName("f3")};
        AttributeGroup group = new AttributeGroup("userFeatures", attrs);
        JavaRDD jrdd = jsc.parallelize((List)Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{Vectors.sparse((int)3, (int[])new int[]{0, 1}, (double[])new double[]{-2.0, 2.3})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3, 0.0})})}));
        DataFrame dataset = jsql.createDataFrame(jrdd, new StructType().add(group.toStructField()));
        VectorSlicer vectorSlicer = new VectorSlicer().setInputCol("userFeatures").setOutputCol("features");
        vectorSlicer.setIndices(new int[]{1}).setNames(new String[]{"f3"});
        DataFrame output = vectorSlicer.transform(dataset);
        System.out.println(output.select("userFeatures", new String[]{"features"}).first());
        jsc.stop();
    }
}

