/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.DCT;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaDCTExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaDCTExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        JavaRDD data = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{1.0, -2.0, 3.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)-1.0, (double[])new double[]{2.0, 4.0, -7.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)14.0, (double[])new double[]{-2.0, -5.0, 1.0})})));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        DataFrame df = jsql.createDataFrame(data, schema);
        DCT dct = ((DCT)((DCT)new DCT().setInputCol("features")).setOutputCol("featuresDCT")).setInverse(false);
        DataFrame dctDf = dct.transform(df);
        dctDf.select("featuresDCT", new String[0]).show(3);
        jsc.stop();
    }
}

