/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.regression.StreamingLinearRegressionWithSGD;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StreamingLinearRegression$ {
    public static final StreamingLinearRegression$ MODULE$;

    static {
        new StreamingLinearRegression$();
    }

    public void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: StreamingLinearRegression <trainingDir> <testDir> <batchDuration> <numFeatures>");
            System.exit(1);
        }
        SparkConf conf = new SparkConf().setMaster("local").setAppName("StreamingLinearRegression");
        StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(args[2])).toLong()));
        DStream trainingData = ssc.textFileStream(args[0]).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String s) {
                return LabeledPoint$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        DStream testData = ssc.textFileStream(args[1]).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String s) {
                return LabeledPoint$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.zeros(new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()));
        model.trainOn(trainingData);
        model.predictOnValues(testData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).print();
        ssc.start();
        ssc.awaitTermination();
    }

    private StreamingLinearRegression$() {
        MODULE$ = this;
    }
}

