/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaNaiveBayesExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaNaiveBayesExample");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        String path = "data/mllib/sample_naive_bayes_data.txt";
        JavaRDD inputData = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)path).toJavaRDD();
        JavaRDD[] tmp = inputData.randomSplit(new double[]{0.6, 0.4}, 12345L);
        JavaRDD training = tmp[0];
        JavaRDD test = tmp[1];
        final NaiveBayesModel model = NaiveBayes.train((RDD)training.rdd(), (double)1.0);
        JavaPairRDD predictionAndLabel = test.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        double accuracy = (double)predictionAndLabel.filter((Function)new Function<Tuple2<Double, Double>, Boolean>(){

            public Boolean call(Tuple2<Double, Double> pl) {
                return ((Double)pl._1()).equals(pl._2());
            }
        }).count() / (double)test.count();
        model.save(jsc.sc(), "target/tmp/myNaiveBayesModel");
        NaiveBayesModel sameModel = NaiveBayesModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myNaiveBayesModel");
    }
}

