/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.rdd.RDD;

public final class JavaKMeans {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: JavaKMeans <input_file> <k> <max_iterations> [<runs>]");
            System.exit(1);
        }
        String inputFile = args[0];
        int k = Integer.parseInt(args[1]);
        int iterations = Integer.parseInt(args[2]);
        int runs = 1;
        if (args.length >= 4) {
            runs = Integer.parseInt(args[3]);
        }
        SparkConf sparkConf = new SparkConf().setAppName("JavaKMeans");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD lines = sc.textFile(inputFile);
        JavaRDD points = lines.map((Function)new ParsePoint());
        KMeansModel model = KMeans.train((RDD)points.rdd(), (int)k, (int)iterations, (int)runs, (String)KMeans.K_MEANS_PARALLEL());
        System.out.println("Cluster centers:");
        for (Vector center : model.clusterCenters()) {
            System.out.println(" " + center);
        }
        double cost = model.computeCost(points.rdd());
        System.out.println("Cost: " + cost);
        sc.stop();
    }

    private static class ParsePoint
    implements Function<String, Vector> {
        private static final Pattern SPACE = Pattern.compile(" ");

        private ParsePoint() {
        }

        public Vector call(String line) {
            String[] tok = SPACE.split(line);
            double[] point = new double[tok.length];
            for (int i = 0; i < tok.length; ++i) {
                point[i] = Double.parseDouble(tok[i]);
            }
            return Vectors.dense((double[])point);
        }
    }
}

