/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.regression.IsotonicRegression;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IsotonicRegressionExample$ {
    public static final IsotonicRegressionExample$ MODULE$;

    static {
        new IsotonicRegressionExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("IsotonicRegressionExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_isotonic_regression_data.txt", sc.textFile$default$2());
        RDD parsedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(String line) {
                double[] parts = (double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(',')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)parts[0]), (Object)BoxesRunTime.boxToDouble((double)parts[1]), (Object)BoxesRunTime.boxToDouble((double)1.0));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD[] splits = parsedData.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0];
        RDD test = splits[1];
        IsotonicRegressionModel model = new IsotonicRegression().setIsotonic(true).run(training);
        RDD predictionAndLabel = test.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final IsotonicRegressionModel model$1;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> point) {
                double predictedLabel = this.model$1.predict(BoxesRunTime.unboxToDouble((Object)point._2()));
                return new Tuple2.mcDD.sp(predictedLabel, BoxesRunTime.unboxToDouble((Object)point._1()));
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double meanSquaredError2 = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictionAndLabel.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double p = tuple2._1$mcD$sp();
                    double l = tuple2._2$mcD$sp();
                    double d = package$.MODULE$.pow(p - l, 2.0);
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Mean Squared Error = ").append((Object)BoxesRunTime.boxToDouble((double)meanSquaredError2)).toString());
        model.save(sc, "target/tmp/myIsotonicRegressionModel");
        IsotonicRegressionModel sameModel = IsotonicRegressionModel$.MODULE$.load(sc, "target/tmp/myIsotonicRegressionModel");
    }

    private IsotonicRegressionExample$() {
        MODULE$ = this;
    }
}

