/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class VectorIndexerExample$ {
    public static final VectorIndexerExample$ MODULE$;

    static {
        new VectorIndexerExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("VectorIndexerExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        DataFrame data = sqlContext.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexer indexer = new VectorIndexer().setInputCol("features").setOutputCol("indexed").setMaxCategories(10);
        VectorIndexerModel indexerModel = indexer.fit(data);
        Set categoricalFeatures = indexerModel.categoryMaps().keys().toSet();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Chose ", " categorical features: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)categoricalFeatures.size())}))).append((Object)categoricalFeatures.mkString(", ")).toString());
        DataFrame indexedData = indexerModel.transform(data);
        indexedData.show();
        sc.stop();
    }

    private VectorIndexerExample$() {
        MODULE$ = this;
    }
}

