/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;

public final class TrainValidationSplitExample$ {
    public static final TrainValidationSplitExample$ MODULE$;

    static {
        new TrainValidationSplitExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("TrainValidationSplitExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        DataFrame data = sqlContext.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        DataFrame[] dataFrameArray = data.randomSplit(new double[]{0.9, 0.1}, 12345L);
        Option option = Array$.MODULE$.unapplySeq((Object)dataFrameArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            DataFrame training = (DataFrame)((SeqLike)option.get()).apply(0);
            DataFrame test = (DataFrame)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            DataFrame training2 = (DataFrame)tuple22._1();
            DataFrame test2 = (DataFrame)tuple22._2();
            LinearRegression lr = new LinearRegression();
            ParamMap[] paramGrid = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.01}).addGrid((Param)lr.fitIntercept(), (Iterable)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).addGrid(lr.elasticNetParam(), new double[]{0.0, 0.5, 1.0}).build();
            TrainValidationSplit trainValidationSplit = new TrainValidationSplit().setEstimator((Estimator)lr).setEvaluator((Evaluator)new RegressionEvaluator()).setEstimatorParamMaps(paramGrid);
            trainValidationSplit.setTrainRatio(0.8);
            TrainValidationSplitModel model = trainValidationSplit.fit(training2);
            model.transform(test2).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "prediction"})).show();
            sc.stop();
            return;
        }
        throw new MatchError((Object)dataFrameArray);
    }

    private TrainValidationSplitExample$() {
        MODULE$ = this;
    }
}

