/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.Document;
import org.apache.spark.examples.ml.LabeledDocument;
import org.apache.spark.examples.ml.SimpleTextClassificationPipeline$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.Tokenizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SimpleTextClassificationPipeline$ {
    public static final SimpleTextClassificationPipeline$ MODULE$;

    static {
        new SimpleTextClassificationPipeline$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SimpleTextClassificationPipeline");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        RDD training = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledDocument[]{new LabeledDocument(0L, "a b c d e spark", 1.0), new LabeledDocument(1L, "b d", 0.0), new LabeledDocument(2L, "spark f g h", 1.0), new LabeledDocument(3L, "hadoop mapreduce", 0.0)})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(LabeledDocument.class));
        Tokenizer tokenizer = (Tokenizer)new Tokenizer().setInputCol("text").setOutputCol("words");
        HashingTF hashingTF = new HashingTF().setNumFeatures(1000).setInputCol(tokenizer.getOutputCol()).setOutputCol("features");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.001);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{tokenizer, hashingTF, lr}));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.LabeledDocument")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator1$1() {
            }
        }
        PipelineModel model = pipeline.fit(sqlContext.implicits().rddToDataFrameHolder(training, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator1$1())).toDF());
        RDD test = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Document[]{new Document(4L, "spark i j k"), new Document(5L, "l m n"), new Document(6L, "spark hadoop spark"), new Document(7L, "apache hadoop")})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Document.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.Document")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator2$1() {
            }
        }
        Predef$.MODULE$.refArrayOps((Object[])model.transform(sqlContext.implicits().rddToDataFrameHolder(test, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_ml_SimpleTextClassificationPipeline$$typecreator2$1())).toDF()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "probability", "prediction"})).collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(4) == 0) {
                    Object id = ((SeqLike)some.get()).apply(0);
                    Object text = ((SeqLike)some.get()).apply(1);
                    Object prob = ((SeqLike)some.get()).apply(2);
                    Object prediction = ((SeqLike)some.get()).apply(3);
                    if (id instanceof Long) {
                        long l = BoxesRunTime.unboxToLong((Object)id);
                        if (text instanceof String) {
                            String string = (String)text;
                            if (prob instanceof Vector) {
                                Vector vector = (Vector)prob;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ") --> prob=", ", prediction=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), string, vector, BoxesRunTime.boxToDouble((double)d)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        });
        sc.stop();
    }

    private SimpleTextClassificationPipeline$() {
        MODULE$ = this;
    }
}

