/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.OneVsRestExample;
import org.apache.spark.examples.ml.OneVsRestExample$;
import org.apache.spark.examples.ml.OneVsRestExample$Params$;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.OneVsRest;
import org.apache.spark.ml.classification.OneVsRestModel;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class OneVsRestExample$ {
    public static final OneVsRestExample$ MODULE$;

    static {
        new OneVsRestExample$();
    }

    public void main(String[] args) {
        OneVsRestExample.Params defaultParams = new OneVsRestExample.Params(OneVsRestExample$Params$.MODULE$.apply$default$1(), OneVsRestExample$Params$.MODULE$.apply$default$2(), OneVsRestExample$Params$.MODULE$.apply$default$3(), OneVsRestExample$Params$.MODULE$.apply$default$4(), OneVsRestExample$Params$.MODULE$.apply$default$5(), OneVsRestExample$Params$.MODULE$.apply$default$6(), OneVsRestExample$Params$.MODULE$.apply$default$7(), OneVsRestExample$Params$.MODULE$.apply$default$8());
        OptionParser<OneVsRestExample.Params> parser = new OptionParser<OneVsRestExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneVsRest Example: multiclass to binary reduction using OneVsRest"}));
                this.opt("input", Read$.MODULE$.stringRead()).text("input path to labeled examples. This path must be specified").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(String x, OneVsRestExample.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8());
                    }
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing.  If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(double x, OneVsRestExample.Params c) {
                        double x$5 = x;
                        String x$6 = c.copy$default$1();
                        Option<String> x$7 = c.copy$default$2();
                        int x$8 = c.copy$default$3();
                        double x$9 = c.copy$default$4();
                        boolean x$10 = c.copy$default$5();
                        Option<Object> x$11 = c.copy$default$6();
                        Option<Object> x$12 = c.copy$default$7();
                        return c.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$5);
                    }
                });
                this.opt("testInput", Read$.MODULE$.stringRead()).text("input path to test dataset.  If given, option fracTest is ignored").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(String x, OneVsRestExample.Params c) {
                        Some x$13 = new Some((Object)x);
                        String x$14 = c.copy$default$1();
                        int x$15 = c.copy$default$3();
                        double x$16 = c.copy$default$4();
                        boolean x$17 = c.copy$default$5();
                        Option<Object> x$18 = c.copy$default$6();
                        Option<Object> x$19 = c.copy$default$7();
                        double x$20 = c.copy$default$8();
                        return c.copy(x$14, (Option<String>)x$13, x$15, x$16, x$17, x$18, x$19, x$20);
                    }
                });
                this.opt("maxIter", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maximum number of iterations for Logistic Regression."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIter())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(int x, OneVsRestExample.Params c) {
                        int x$21 = x;
                        String x$22 = c.copy$default$1();
                        Option<String> x$23 = c.copy$default$2();
                        double x$24 = c.copy$default$4();
                        boolean x$25 = c.copy$default$5();
                        Option<Object> x$26 = c.copy$default$6();
                        Option<Object> x$27 = c.copy$default$7();
                        double x$28 = c.copy$default$8();
                        return c.copy(x$22, x$23, x$21, x$24, x$25, x$26, x$27, x$28);
                    }
                });
                this.opt("tol", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the convergence tolerance of iterations for Logistic Regression."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.tol())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(double x, OneVsRestExample.Params c) {
                        double x$29 = x;
                        String x$30 = c.copy$default$1();
                        Option<String> x$31 = c.copy$default$2();
                        int x$32 = c.copy$default$3();
                        boolean x$33 = c.copy$default$5();
                        Option<Object> x$34 = c.copy$default$6();
                        Option<Object> x$35 = c.copy$default$7();
                        double x$36 = c.copy$default$8();
                        return c.copy(x$30, x$31, x$32, x$29, x$33, x$34, x$35, x$36);
                    }
                });
                this.opt("fitIntercept", Read$.MODULE$.booleanRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fit intercept for Logistic Regression."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)defaultParams$1.fitIntercept())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(boolean x, OneVsRestExample.Params c) {
                        boolean x$37 = x;
                        String x$38 = c.copy$default$1();
                        Option<String> x$39 = c.copy$default$2();
                        int x$40 = c.copy$default$3();
                        double x$41 = c.copy$default$4();
                        Option<Object> x$42 = c.copy$default$6();
                        Option<Object> x$43 = c.copy$default$7();
                        double x$44 = c.copy$default$8();
                        return c.copy(x$38, x$39, x$40, x$41, x$37, x$42, x$43, x$44);
                    }
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the regularization parameter for Logistic Regression."})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(double x, OneVsRestExample.Params c) {
                        Some x$45 = new Some((Object)BoxesRunTime.boxToDouble((double)x));
                        String x$46 = c.copy$default$1();
                        Option<String> x$47 = c.copy$default$2();
                        int x$48 = c.copy$default$3();
                        double x$49 = c.copy$default$4();
                        boolean x$50 = c.copy$default$5();
                        Option<Object> x$51 = c.copy$default$7();
                        double x$52 = c.copy$default$8();
                        return c.copy(x$46, x$47, x$48, x$49, x$50, (Option<Object>)x$45, x$51, x$52);
                    }
                });
                this.opt("elasticNetParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the ElasticNet mixing parameter for Logistic Regression."})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final OneVsRestExample.Params apply(double x, OneVsRestExample.Params c) {
                        Some x$53 = new Some((Object)BoxesRunTime.boxToDouble((double)x));
                        String x$54 = c.copy$default$1();
                        Option<String> x$55 = c.copy$default$2();
                        int x$56 = c.copy$default$3();
                        double x$57 = c.copy$default$4();
                        boolean x$58 = c.copy$default$5();
                        Option<Object> x$59 = c.copy$default$6();
                        double x$60 = c.copy$default$8();
                        return c.copy(x$54, x$55, x$56, x$57, x$58, x$59, (Option<Object>)x$53, x$60);
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(OneVsRestExample.Params params) {
                        return params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())}))) : this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(OneVsRestExample.Params params) {
                OneVsRestExample$.MODULE$.org$apache$spark$examples$ml$OneVsRestExample$$run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
    }

    public void org$apache$spark$examples$ml$OneVsRestExample$$run(OneVsRestExample.Params params) {
        Option<String> option;
        block8: {
            DataFrame[] dataFrameArray;
            SparkContext sc;
            block7: {
                DataFrame inputData;
                block6: {
                    SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneVsRestExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                    sc = new SparkContext(conf);
                    SQLContext sqlContext = new SQLContext(sc);
                    inputData = sqlContext.read().format("libsvm").load(params.input());
                    option = params.testInput();
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    String t = (String)some.x();
                    int numFeatures = ((Vector)inputData.first().getAs(1)).size();
                    DataFrame testData = sqlContext.read().option("numFeatures", ((Object)BoxesRunTime.boxToInteger((int)numFeatures)).toString()).format("libsvm").load(t);
                    dataFrameArray = (DataFrame[])((Object[])new DataFrame[]{inputData, testData});
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                double f = params.fracTest();
                dataFrameArray = inputData.randomSplit(new double[]{1.0 - f, f}, 12345L);
            }
            DataFrame[] data = dataFrameArray;
            DataFrame[] dataFrameArray2 = (DataFrame[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new anonfun.10(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFrame.class)));
            Option option3 = Array$.MODULE$.unapplySeq((Object)dataFrameArray2);
            if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
                Tuple2 tuple2;
                DataFrame train = (DataFrame)((SeqLike)option3.get()).apply(0);
                DataFrame test = (DataFrame)((SeqLike)option3.get()).apply(1);
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)train, (Object)test);
                DataFrame train2 = (DataFrame)tuple22._1();
                DataFrame test2 = (DataFrame)tuple22._2();
                LogisticRegression classifier = new LogisticRegression().setMaxIter(params.maxIter()).setTol(params.tol()).setFitIntercept(params.fitIntercept());
                params.regParam().foreach((Function1)new Serializable(classifier){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegression classifier$1;

                    public final LogisticRegression apply(double value) {
                        return this.classifier$1.setRegParam(value);
                    }
                    {
                        this.classifier$1 = classifier$1;
                    }
                });
                params.elasticNetParam().foreach((Function1)new Serializable(classifier){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegression classifier$1;

                    public final LogisticRegression apply(double value) {
                        return this.classifier$1.setElasticNetParam(value);
                    }
                    {
                        this.classifier$1 = classifier$1;
                    }
                });
                OneVsRest ovr = new OneVsRest();
                ovr.setClassifier((Classifier)classifier);
                Tuple2 tuple23 = this.time((Function0)new anonfun.11(train2, ovr));
                if (tuple23 != null) {
                    Tuple2 tuple24;
                    long trainingDuration = tuple23._1$mcJ$sp();
                    OneVsRestModel ovrModel = (OneVsRestModel)tuple23._2();
                    Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToLong((long)trainingDuration), (Object)ovrModel);
                    long trainingDuration2 = tuple25._1$mcJ$sp();
                    OneVsRestModel ovrModel2 = (OneVsRestModel)tuple25._2();
                    Tuple2 tuple26 = this.time((Function0)new anonfun.12(test2, ovrModel2));
                    if (tuple26 != null) {
                        Tuple2 tuple27;
                        long predictionDuration = tuple26._1$mcJ$sp();
                        DataFrame predictions = (DataFrame)tuple26._2();
                        Tuple2 tuple28 = tuple27 = new Tuple2((Object)BoxesRunTime.boxToLong((long)predictionDuration), (Object)predictions);
                        long predictionDuration2 = tuple28._1$mcJ$sp();
                        DataFrame predictions2 = (DataFrame)tuple28._2();
                        RDD predictionsAndLabels = predictions2.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Row row) {
                                return new Tuple2.mcDD.sp(row.getDouble(0), row.getDouble(1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        MulticlassMetrics metrics = new MulticlassMetrics(predictionsAndLabels);
                        Matrix confusionMatrix = metrics.confusionMatrix();
                        StructField predictionColSchema = predictions2.schema().apply("prediction");
                        int numClasses = BoxesRunTime.unboxToInt((Object)MetadataUtils$.MODULE$.getNumClasses(predictionColSchema).get());
                        IndexedSeq fprs = (IndexedSeq)package$.MODULE$.Range().apply(0, numClasses).map((Function1)new Serializable(metrics){
                            public static final long serialVersionUID = 0L;
                            private final MulticlassMetrics metrics$1;

                            public final Tuple2<Object, Object> apply(int p) {
                                return new Tuple2.mcID.sp(p, this.metrics$1.falsePositiveRate((double)p));
                            }
                            {
                                this.metrics$1 = metrics$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Training Time ", " sec\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trainingDuration2)})));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Prediction Time ", " sec\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)predictionDuration2)})));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Confusion Matrix\\n ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{confusionMatrix.toString()})));
                        Predef$.MODULE$.println((Object)"label\tfpr");
                        Predef$.MODULE$.println((Object)((TraversableOnce)fprs.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    int label = tuple2._1$mcI$sp();
                                    double fpr = tuple2._2$mcD$sp();
                                    String string = new StringBuilder().append(label).append((Object)"\t").append((Object)BoxesRunTime.boxToDouble((double)fpr)).toString();
                                    return string;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n"));
                        sc.stop();
                        return;
                    }
                    throw new MatchError(tuple26);
                }
                throw new MatchError(tuple23);
            }
            throw new MatchError((Object)dataFrameArray2);
        }
        throw new MatchError(option);
    }

    private <R> Tuple2<Object, R> time(Function0<R> block) {
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toSeconds(t1 - t0)), result);
    }

    private OneVsRestExample$() {
        MODULE$ = this;
    }
}

