/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class LogisticRegressionSummaryExample$ {
    public static final LogisticRegressionSummaryExample$ MODULE$;

    static {
        new LogisticRegressionSummaryExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LogisticRegressionSummaryExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlCtx = new SQLContext(sc);
        DataFrame training = sqlCtx.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        LogisticRegressionTrainingSummary trainingSummary = lrModel.summary();
        double[] objectiveHistory = trainingSummary.objectiveHistory();
        Predef$.MODULE$.doubleArrayOps(objectiveHistory).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(double loss) {
                this.apply$mcVD$sp(loss);
            }

            public void apply$mcVD$sp(double loss) {
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)loss));
            }
        });
        BinaryLogisticRegressionSummary binarySummary = (BinaryLogisticRegressionSummary)trainingSummary;
        DataFrame roc = binarySummary.roc();
        roc.show();
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)binarySummary.areaUnderROC()));
        DataFrame fMeasure = binarySummary.fMeasureByThreshold();
        double maxFMeasure = fMeasure.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("F-Measure")})).head().getDouble(0);
        double bestThreshold = fMeasure.where(sqlCtx.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"F-Measure"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)maxFMeasure))).select("threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head().getDouble(0);
        lrModel.setThreshold(bestThreshold);
        sc.stop();
    }

    private LogisticRegressionSummaryExample$() {
        MODULE$ = this;
    }
}

