/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.LinearRegressionExample;
import org.apache.spark.examples.ml.LinearRegressionExample$;
import org.apache.spark.examples.ml.LinearRegressionExample$Params$;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.sql.DataFrame;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class LinearRegressionExample$ {
    public static final LinearRegressionExample$ MODULE$;

    static {
        new LinearRegressionExample$();
    }

    public void main(String[] args) {
        LinearRegressionExample.Params defaultParams = new LinearRegressionExample.Params(LinearRegressionExample$Params$.MODULE$.apply$default$1(), LinearRegressionExample$Params$.MODULE$.apply$default$2(), LinearRegressionExample$Params$.MODULE$.apply$default$3(), LinearRegressionExample$Params$.MODULE$.apply$default$4(), LinearRegressionExample$Params$.MODULE$.apply$default$5(), LinearRegressionExample$Params$.MODULE$.apply$default$6(), LinearRegressionExample$Params$.MODULE$.apply$default$7(), LinearRegressionExample$Params$.MODULE$.apply$default$8());
        OptionParser<LinearRegressionExample.Params> parser = new OptionParser<LinearRegressionExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegressionExample: an example Linear Regression with Elastic-Net app."}));
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization parameter, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.regParam())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(double x, LinearRegressionExample.Params c) {
                        double x$2 = x;
                        String x$3 = c.copy$default$1();
                        String x$4 = c.copy$default$2();
                        String x$5 = c.copy$default$3();
                        double x$6 = c.copy$default$5();
                        int x$7 = c.copy$default$6();
                        double x$8 = c.copy$default$7();
                        double x$9 = c.copy$default$8();
                        return c.copy(x$3, x$4, x$5, x$2, x$6, x$7, x$8, x$9);
                    }
                });
                this.opt("elasticNetParam", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ElasticNet mixing parameter. For alpha = 0, the penalty is an L2 penalty. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For alpha = 1, it is an L1 penalty. For 0 < alpha < 1, the penalty is a combination of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"L1 and L2, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.elasticNetParam())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(double x, LinearRegressionExample.Params c) {
                        double x$10 = x;
                        String x$11 = c.copy$default$1();
                        String x$12 = c.copy$default$2();
                        String x$13 = c.copy$default$3();
                        double x$14 = c.copy$default$4();
                        int x$15 = c.copy$default$6();
                        double x$16 = c.copy$default$7();
                        double x$17 = c.copy$default$8();
                        return c.copy(x$11, x$12, x$13, x$14, x$10, x$15, x$16, x$17);
                    }
                });
                this.opt("maxIter", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maximum number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIter())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(int x, LinearRegressionExample.Params c) {
                        int x$18 = x;
                        String x$19 = c.copy$default$1();
                        String x$20 = c.copy$default$2();
                        String x$21 = c.copy$default$3();
                        double x$22 = c.copy$default$4();
                        double x$23 = c.copy$default$5();
                        double x$24 = c.copy$default$7();
                        double x$25 = c.copy$default$8();
                        return c.copy(x$19, x$20, x$21, x$22, x$23, x$18, x$24, x$25);
                    }
                });
                this.opt("tol", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the convergence tolerance of iterations, Smaller value will lead "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to higher accuracy with the cost of more iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.tol())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(double x, LinearRegressionExample.Params c) {
                        double x$26 = x;
                        String x$27 = c.copy$default$1();
                        String x$28 = c.copy$default$2();
                        String x$29 = c.copy$default$3();
                        double x$30 = c.copy$default$4();
                        double x$31 = c.copy$default$5();
                        int x$32 = c.copy$default$6();
                        double x$33 = c.copy$default$8();
                        return c.copy(x$27, x$28, x$29, x$30, x$31, x$32, x$26, x$33);
                    }
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing.  If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(double x, LinearRegressionExample.Params c) {
                        double x$34 = x;
                        String x$35 = c.copy$default$1();
                        String x$36 = c.copy$default$2();
                        String x$37 = c.copy$default$3();
                        double x$38 = c.copy$default$4();
                        double x$39 = c.copy$default$5();
                        int x$40 = c.copy$default$6();
                        double x$41 = c.copy$default$7();
                        return c.copy(x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$34);
                    }
                });
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to test dataset.  If given, option fracTest is ignored."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.testInput()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(String x, LinearRegressionExample.Params c) {
                        String x$42 = x;
                        String x$43 = c.copy$default$1();
                        String x$44 = c.copy$default$3();
                        double x$45 = c.copy$default$4();
                        double x$46 = c.copy$default$5();
                        int x$47 = c.copy$default$6();
                        double x$48 = c.copy$default$7();
                        double x$49 = c.copy$default$8();
                        return c.copy(x$43, x$42, x$44, x$45, x$46, x$47, x$48, x$49);
                    }
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(String x, LinearRegressionExample.Params c) {
                        String x$50 = x;
                        String x$51 = c.copy$default$1();
                        String x$52 = c.copy$default$2();
                        double x$53 = c.copy$default$4();
                        double x$54 = c.copy$default$5();
                        int x$55 = c.copy$default$6();
                        double x$56 = c.copy$default$7();
                        double x$57 = c.copy$default$8();
                        return c.copy(x$51, x$52, x$50, x$53, x$54, x$55, x$56, x$57);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LinearRegressionExample.Params apply(String x, LinearRegressionExample.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8());
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(LinearRegressionExample.Params params) {
                        return params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())}))) : this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LinearRegressionExample.Params params) {
                LinearRegressionExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(LinearRegressionExample.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegressionExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegressionExample with parameters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        Tuple2<DataFrame, DataFrame> tuple2 = DecisionTreeExample$.MODULE$.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), "regression", params.fracTest());
        if (tuple2 != null) {
            DataFrame training = (DataFrame)tuple2._1();
            DataFrame test = (DataFrame)tuple2._2();
            if (training != null) {
                DataFrame dataFrame = training;
                if (test != null) {
                    Tuple2 tuple22;
                    DataFrame dataFrame2 = test;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataFrame, (Object)dataFrame2);
                    DataFrame training2 = (DataFrame)tuple23._1();
                    DataFrame test2 = (DataFrame)tuple23._2();
                    LinearRegression lir = ((LinearRegression)new LinearRegression().setFeaturesCol("features").setLabelCol("label")).setRegParam(params.regParam()).setElasticNetParam(params.elasticNetParam()).setMaxIter(params.maxIter()).setTol(params.tol());
                    long startTime = System.nanoTime();
                    LinearRegressionModel lirModel = (LinearRegressionModel)lir.fit(training2);
                    double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weights: ", " Intercept: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lirModel.coefficients(), BoxesRunTime.boxToDouble((double)lirModel.intercept())})));
                    Predef$.MODULE$.println((Object)"Training data results:");
                    DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)lirModel, training2, "label");
                    Predef$.MODULE$.println((Object)"Test data results:");
                    DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)lirModel, test2, "label");
                    sc.stop();
                    return;
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private LinearRegressionExample$() {
        MODULE$ = this;
    }
}

