/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;

public class JavaVectorIndexerExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaVectorIndexerExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        DataFrame data = jsql.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexer indexer = new VectorIndexer().setInputCol("features").setOutputCol("indexed").setMaxCategories(10);
        VectorIndexerModel indexerModel = indexer.fit(data);
        Map categoryMaps = indexerModel.javaCategoryMaps();
        System.out.print("Chose " + categoryMaps.size() + " categorical features:");
        for (Integer feature : categoryMaps.keySet()) {
            System.out.print(" " + feature);
        }
        System.out.println();
        DataFrame indexedData = indexerModel.transform(data);
        indexedData.show();
        jsc.stop();
    }
}

