/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaVectorAssemblerExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaVectorAssemblerExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"hour", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"mobile", (DataType)DataTypes.DoubleType, (boolean)false), DataTypes.createStructField((String)"userFeatures", (DataType)new VectorUDT(), (boolean)false), DataTypes.createStructField((String)"clicked", (DataType)DataTypes.DoubleType, (boolean)false)});
        Row row = RowFactory.create((Object[])new Object[]{0, 18, 1.0, Vectors.dense((double)0.0, (double[])new double[]{10.0, 0.5}), 1.0});
        JavaRDD rdd = jsc.parallelize(Arrays.asList(row));
        DataFrame dataset = sqlContext.createDataFrame(rdd, schema);
        VectorAssembler assembler = new VectorAssembler().setInputCols(new String[]{"hour", "mobile", "userFeatures"}).setOutputCol("features");
        DataFrame output = assembler.transform(dataset);
        System.out.println(output.select("features", new String[]{"clicked"}).first());
        jsc.stop();
    }
}

