/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaRFormulaExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaRFormulaExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"country", (DataType)DataTypes.StringType, (boolean)false), DataTypes.createStructField((String)"hour", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"clicked", (DataType)DataTypes.DoubleType, (boolean)false)});
        JavaRDD rdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{7, "US", 18, 1.0}), RowFactory.create((Object[])new Object[]{8, "CA", 12, 0.0}), RowFactory.create((Object[])new Object[]{9, "NZ", 15, 0.0})));
        DataFrame dataset = sqlContext.createDataFrame(rdd, schema);
        RFormula formula = new RFormula().setFormula("clicked ~ country + hour").setFeaturesCol("features").setLabelCol("label");
        DataFrame output = formula.fit(dataset).transform(dataset);
        output.select("features", new String[]{"label"}).show();
        jsc.stop();
    }
}

