/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaPolynomialExpansionExample {
    public static void main(String[] args) {
        Row[] row;
        SparkConf conf = new SparkConf().setAppName("JavaPolynomialExpansionExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        PolynomialExpansion polyExpansion = ((PolynomialExpansion)((PolynomialExpansion)new PolynomialExpansion().setInputCol("features")).setOutputCol("polyFeatures")).setDegree(3);
        JavaRDD data = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{0.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.6, (double[])new double[]{-1.1})})));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        DataFrame df = jsql.createDataFrame(data, schema);
        DataFrame polyDF = polyExpansion.transform(df);
        for (Row r : row = polyDF.select("polyFeatures", new String[0]).take(3)) {
            System.out.println(r.get(0));
        }
        jsc.stop();
    }
}

