/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.PCA;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaPCAExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaPCAExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        JavaRDD data = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.sparse((int)5, (int[])new int[]{1, 3}, (double[])new double[]{1.0, 7.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)2.0, (double[])new double[]{0.0, 3.0, 4.0, 5.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)4.0, (double[])new double[]{0.0, 0.0, 6.0, 7.0})})));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        DataFrame df = jsql.createDataFrame(data, schema);
        PCAModel pca = new PCA().setInputCol("features").setOutputCol("pcaFeatures").setK(3).fit(df);
        DataFrame result = pca.transform(df).select("pcaFeatures", new String[0]);
        result.show();
        jsc.stop();
    }
}

