/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;

public class JavaMultilayerPerceptronClassifierExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaMultilayerPerceptronClassifierExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        String path = "data/mllib/sample_multiclass_classification_data.txt";
        DataFrame dataFrame = jsql.read().format("libsvm").load(path);
        DataFrame[] splits = dataFrame.randomSplit(new double[]{0.6, 0.4}, 1234L);
        DataFrame train = splits[0];
        DataFrame test = splits[1];
        int[] layers = new int[]{4, 5, 4, 3};
        MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(100);
        MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(train);
        DataFrame result = model.transform(test);
        DataFrame predictionAndLabels = result.select("prediction", new String[]{"label"});
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("precision");
        System.out.println("Precision = " + evaluator.evaluate(predictionAndLabels));
        jsc.stop();
    }
}

