/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaIndexToStringExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaIndexToStringExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD jrdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{0, "a"}), RowFactory.create((Object[])new Object[]{1, "b"}), RowFactory.create((Object[])new Object[]{2, "c"}), RowFactory.create((Object[])new Object[]{3, "a"}), RowFactory.create((Object[])new Object[]{4, "a"}), RowFactory.create((Object[])new Object[]{5, "c"})));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("category", DataTypes.StringType, false, Metadata.empty())});
        DataFrame df = sqlContext.createDataFrame(jrdd, schema);
        StringIndexerModel indexer = new StringIndexer().setInputCol("category").setOutputCol("categoryIndex").fit(df);
        DataFrame indexed = indexer.transform(df);
        IndexToString converter = new IndexToString().setInputCol("categoryIndex").setOutputCol("originalCategory");
        DataFrame converted = converter.transform(indexed);
        converted.select("id", new String[]{"originalCategory"}).show();
        jsc.stop();
    }
}

