/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.examples.ml.MyJavaLogisticRegression;
import org.apache.spark.examples.ml.MyJavaLogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;

public class JavaDeveloperApiExample {
    public static void main(String[] args) throws Exception {
        SparkConf conf = new SparkConf().setAppName("JavaDeveloperApiExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        ArrayList localTraining = Lists.newArrayList((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{1.1, 0.1})), new LabeledPoint(0.0, Vectors.dense((double)2.0, (double[])new double[]{1.0, -1.0})), new LabeledPoint(0.0, Vectors.dense((double)2.0, (double[])new double[]{1.3, 1.0})), new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{1.2, -0.5}))});
        DataFrame training = jsql.createDataFrame(jsc.parallelize((List)localTraining), LabeledPoint.class);
        MyJavaLogisticRegression lr = new MyJavaLogisticRegression();
        System.out.println("MyJavaLogisticRegression parameters:\n" + lr.explainParams() + "\n");
        lr.setMaxIter(10);
        MyJavaLogisticRegressionModel model = (MyJavaLogisticRegressionModel)lr.fit(training);
        ArrayList localTest = Lists.newArrayList((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors.dense((double)-1.0, (double[])new double[]{1.5, 1.3})), new LabeledPoint(0.0, Vectors.dense((double)3.0, (double[])new double[]{2.0, -0.1})), new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{2.2, -1.5}))});
        DataFrame test = jsql.createDataFrame(jsc.parallelize((List)localTest), LabeledPoint.class);
        DataFrame results = model.transform(test);
        double sumPredictions = 0.0;
        for (Row r : results.select("features", new String[]{"label", "prediction"}).collect()) {
            sumPredictions += r.getDouble(2);
        }
        if (sumPredictions != 0.0) {
            throw new Exception("MyJavaLogisticRegression predicted something other than 0, even though all weights are 0!");
        }
        jsc.stop();
    }
}

