/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;

public class JavaDecisionTreeRegressionExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaDecisionTreeRegressionExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        DataFrame data = sqlContext.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        DataFrame[] splits = data.randomSplit(new double[]{0.7, 0.3});
        DataFrame trainingData = splits[0];
        DataFrame testData = splits[1];
        DecisionTreeRegressor dt = (DecisionTreeRegressor)new DecisionTreeRegressor().setFeaturesCol("indexedFeatures");
        Pipeline pipeline = new Pipeline().setStages(new PipelineStage[]{featureIndexer, dt});
        PipelineModel model = pipeline.fit(trainingData);
        DataFrame predictions = model.transform(testData);
        predictions.select("label", new String[]{"features"}).show(5);
        RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
        double rmse2 = evaluator.evaluate(predictions);
        System.out.println("Root Mean Squared Error (RMSE) on test data = " + rmse2);
        DecisionTreeRegressionModel treeModel = (DecisionTreeRegressionModel)model.stages()[1];
        System.out.println("Learned regression tree model:\n" + treeModel.toDebugString());
    }
}

