/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.DecisionTreeExample;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.DecisionTreeExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class DecisionTreeExample$ {
    public static final DecisionTreeExample$ MODULE$;

    static {
        new DecisionTreeExample$();
    }

    public void main(String[] args) {
        DecisionTreeExample.Params defaultParams = new DecisionTreeExample.Params(DecisionTreeExample$Params$.MODULE$.apply$default$1(), DecisionTreeExample$Params$.MODULE$.apply$default$2(), DecisionTreeExample$Params$.MODULE$.apply$default$3(), DecisionTreeExample$Params$.MODULE$.apply$default$4(), DecisionTreeExample$Params$.MODULE$.apply$default$5(), DecisionTreeExample$Params$.MODULE$.apply$default$6(), DecisionTreeExample$Params$.MODULE$.apply$default$7(), DecisionTreeExample$Params$.MODULE$.apply$default$8(), DecisionTreeExample$Params$.MODULE$.apply$default$9(), DecisionTreeExample$Params$.MODULE$.apply$default$10(), DecisionTreeExample$Params$.MODULE$.apply$default$11(), DecisionTreeExample$Params$.MODULE$.apply$default$12());
        OptionParser<DecisionTreeExample.Params> parser = new OptionParser<DecisionTreeExample.Params>(defaultParams){
            {
                Option<String> option;
                block4: {
                    String string;
                    Object[] objectArray;
                    StringContext stringContext;
                    StringBuilder stringBuilder;
                    OptionDef optionDef;
                    block3: {
                        block2: {
                            String strVal;
                            super("DecisionTreeExample");
                            this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeExample: an example decision tree app."}));
                            this.opt("algo", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"algorithm (classification, regression), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.algo()}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(String x, DecisionTreeExample.Params c) {
                                    String x$6 = x;
                                    String x$7 = c.copy$default$1();
                                    String x$8 = c.copy$default$2();
                                    String x$9 = c.copy$default$3();
                                    int x$10 = c.copy$default$5();
                                    int x$11 = c.copy$default$6();
                                    int x$12 = c.copy$default$7();
                                    double x$13 = c.copy$default$8();
                                    double x$14 = c.copy$default$9();
                                    boolean x$15 = c.copy$default$10();
                                    Option<String> x$16 = c.copy$default$11();
                                    int x$17 = c.copy$default$12();
                                    return c.copy(x$7, x$8, x$9, x$6, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                                }
                            });
                            this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max depth of the tree, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxDepth())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(int x, DecisionTreeExample.Params c) {
                                    int x$18 = x;
                                    String x$19 = c.copy$default$1();
                                    String x$20 = c.copy$default$2();
                                    String x$21 = c.copy$default$3();
                                    String x$22 = c.copy$default$4();
                                    int x$23 = c.copy$default$6();
                                    int x$24 = c.copy$default$7();
                                    double x$25 = c.copy$default$8();
                                    double x$26 = c.copy$default$9();
                                    boolean x$27 = c.copy$default$10();
                                    Option<String> x$28 = c.copy$default$11();
                                    int x$29 = c.copy$default$12();
                                    return c.copy(x$19, x$20, x$21, x$22, x$18, x$23, x$24, x$25, x$26, x$27, x$28, x$29);
                                }
                            });
                            this.opt("maxBins", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max number of bins, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxBins())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(int x, DecisionTreeExample.Params c) {
                                    int x$30 = x;
                                    String x$31 = c.copy$default$1();
                                    String x$32 = c.copy$default$2();
                                    String x$33 = c.copy$default$3();
                                    String x$34 = c.copy$default$4();
                                    int x$35 = c.copy$default$5();
                                    int x$36 = c.copy$default$7();
                                    double x$37 = c.copy$default$8();
                                    double x$38 = c.copy$default$9();
                                    boolean x$39 = c.copy$default$10();
                                    Option<String> x$40 = c.copy$default$11();
                                    int x$41 = c.copy$default$12();
                                    return c.copy(x$31, x$32, x$33, x$34, x$35, x$30, x$36, x$37, x$38, x$39, x$40, x$41);
                                }
                            });
                            this.opt("minInstancesPerNode", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min number of instances required at child nodes to create the parent split,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.minInstancesPerNode())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(int x, DecisionTreeExample.Params c) {
                                    int x$42 = x;
                                    String x$43 = c.copy$default$1();
                                    String x$44 = c.copy$default$2();
                                    String x$45 = c.copy$default$3();
                                    String x$46 = c.copy$default$4();
                                    int x$47 = c.copy$default$5();
                                    int x$48 = c.copy$default$6();
                                    double x$49 = c.copy$default$8();
                                    double x$50 = c.copy$default$9();
                                    boolean x$51 = c.copy$default$10();
                                    Option<String> x$52 = c.copy$default$11();
                                    int x$53 = c.copy$default$12();
                                    return c.copy(x$43, x$44, x$45, x$46, x$47, x$48, x$42, x$49, x$50, x$51, x$52, x$53);
                                }
                            });
                            this.opt("minInfoGain", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min info gain required to create a split, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.minInfoGain())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(double x, DecisionTreeExample.Params c) {
                                    double x$54 = x;
                                    String x$55 = c.copy$default$1();
                                    String x$56 = c.copy$default$2();
                                    String x$57 = c.copy$default$3();
                                    String x$58 = c.copy$default$4();
                                    int x$59 = c.copy$default$5();
                                    int x$60 = c.copy$default$6();
                                    int x$61 = c.copy$default$7();
                                    double x$62 = c.copy$default$9();
                                    boolean x$63 = c.copy$default$10();
                                    Option<String> x$64 = c.copy$default$11();
                                    int x$65 = c.copy$default$12();
                                    return c.copy(x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$54, x$62, x$63, x$64, x$65);
                                }
                            });
                            this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing.  If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(double x, DecisionTreeExample.Params c) {
                                    double x$66 = x;
                                    String x$67 = c.copy$default$1();
                                    String x$68 = c.copy$default$2();
                                    String x$69 = c.copy$default$3();
                                    String x$70 = c.copy$default$4();
                                    int x$71 = c.copy$default$5();
                                    int x$72 = c.copy$default$6();
                                    int x$73 = c.copy$default$7();
                                    double x$74 = c.copy$default$8();
                                    boolean x$75 = c.copy$default$10();
                                    Option<String> x$76 = c.copy$default$11();
                                    int x$77 = c.copy$default$12();
                                    return c.copy(x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$66, x$75, x$76, x$77);
                                }
                            });
                            this.opt("cacheNodeIds", Read$.MODULE$.booleanRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"whether to use node Id cache during training, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)defaultParams$1.cacheNodeIds())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeExample.Params apply(boolean x, DecisionTreeExample.Params c) {
                                    boolean x$78 = x;
                                    String x$79 = c.copy$default$1();
                                    String x$80 = c.copy$default$2();
                                    String x$81 = c.copy$default$3();
                                    String x$82 = c.copy$default$4();
                                    int x$83 = c.copy$default$5();
                                    int x$84 = c.copy$default$6();
                                    int x$85 = c.copy$default$7();
                                    double x$86 = c.copy$default$8();
                                    double x$87 = c.copy$default$9();
                                    Option<String> x$88 = c.copy$default$11();
                                    int x$89 = c.copy$default$12();
                                    return c.copy(x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$78, x$88, x$89);
                                }
                            });
                            optionDef = this.opt("checkpointDir", Read$.MODULE$.stringRead());
                            stringBuilder = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkpoint directory where intermediate node Id caches will be stored, "})).s((Seq)Nil$.MODULE$));
                            stringContext = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""}));
                            objectArray = new Object[1];
                            option = defaultParams$1.checkpointDir();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            string = strVal = (String)some.x();
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        string = "None";
                    }
                    objectArray[0] = string;
                    optionDef.text(stringBuilder.append((Object)stringContext.s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeExample.Params apply(String x, DecisionTreeExample.Params c) {
                            Some x$90 = new Some((Object)x);
                            String x$91 = c.copy$default$1();
                            String x$92 = c.copy$default$2();
                            String x$93 = c.copy$default$3();
                            String x$94 = c.copy$default$4();
                            int x$95 = c.copy$default$5();
                            int x$96 = c.copy$default$6();
                            int x$97 = c.copy$default$7();
                            double x$98 = c.copy$default$8();
                            double x$99 = c.copy$default$9();
                            boolean x$100 = c.copy$default$10();
                            int x$101 = c.copy$default$12();
                            return c.copy(x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, (Option<String>)x$90, x$101);
                        }
                    });
                    this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"how often to checkpoint the node Id cache, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.checkpointInterval())}))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeExample.Params apply(int x, DecisionTreeExample.Params c) {
                            int x$102 = x;
                            String x$103 = c.copy$default$1();
                            String x$104 = c.copy$default$2();
                            String x$105 = c.copy$default$3();
                            String x$106 = c.copy$default$4();
                            int x$107 = c.copy$default$5();
                            int x$108 = c.copy$default$6();
                            int x$109 = c.copy$default$7();
                            double x$110 = c.copy$default$8();
                            double x$111 = c.copy$default$9();
                            boolean x$112 = c.copy$default$10();
                            Option<String> x$113 = c.copy$default$11();
                            return c.copy(x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$102);
                        }
                    });
                    this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to test dataset.  If given, option fracTest is ignored."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.testInput()}))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeExample.Params apply(String x, DecisionTreeExample.Params c) {
                            String x$114 = x;
                            String x$115 = c.copy$default$1();
                            String x$116 = c.copy$default$3();
                            String x$117 = c.copy$default$4();
                            int x$118 = c.copy$default$5();
                            int x$119 = c.copy$default$6();
                            int x$120 = c.copy$default$7();
                            double x$121 = c.copy$default$8();
                            double x$122 = c.copy$default$9();
                            boolean x$123 = c.copy$default$10();
                            Option<String> x$124 = c.copy$default$11();
                            int x$125 = c.copy$default$12();
                            return c.copy(x$115, x$114, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125);
                        }
                    });
                    this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeExample.Params apply(String x, DecisionTreeExample.Params c) {
                            String x$126 = x;
                            String x$127 = c.copy$default$1();
                            String x$128 = c.copy$default$2();
                            String x$129 = c.copy$default$4();
                            int x$130 = c.copy$default$5();
                            int x$131 = c.copy$default$6();
                            int x$132 = c.copy$default$7();
                            double x$133 = c.copy$default$8();
                            double x$134 = c.copy$default$9();
                            boolean x$135 = c.copy$default$10();
                            Option<String> x$136 = c.copy$default$11();
                            int x$137 = c.copy$default$12();
                            return c.copy(x$127, x$128, x$126, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137);
                        }
                    });
                    this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeExample.Params apply(String x, DecisionTreeExample.Params c) {
                            return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12());
                        }
                    });
                    this.checkConfig((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;

                        public final Either<String, BoxedUnit> apply(DecisionTreeExample.Params params) {
                            return params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())}))) : this.$outer.success();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError(option);
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(DecisionTreeExample.Params params) {
                DecisionTreeExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
    }

    public DataFrame loadData(SQLContext sqlContext, String path, String format, Option<Object> expectedNumFeatures) {
        block4: {
            Option<Object> option;
            block7: {
                DataFrame dataFrame;
                block3: {
                    DataFrame dataFrame2;
                    block6: {
                        block5: {
                            String string;
                            block2: {
                                String string2 = string = format;
                                if ("dense" != null ? !"dense".equals(string2) : string2 != null) break block2;
                                JavaUniverse $u = package$.MODULE$.universe();
                                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                                public final class Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator2$1
                                extends TypeCreator {
                                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                        Universe $u = $m$untyped.universe();
                                        Mirror<U> $m = $m$untyped;
                                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                                    }

                                    public Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator2$1() {
                                    }
                                }
                                dataFrame = sqlContext.implicits().rddToDataFrameHolder(MLUtils$.MODULE$.loadLabeledPoints(sqlContext.sparkContext(), path), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator2$1())).toDF();
                                break block3;
                            }
                            String string3 = string;
                            if ("libsvm" != null ? !"libsvm".equals(string3) : string3 != null) break block4;
                            option = expectedNumFeatures;
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            int numFeatures = BoxesRunTime.unboxToInt((Object)some.x());
                            dataFrame2 = sqlContext.read().option("numFeatures", ((Object)BoxesRunTime.boxToInteger((int)numFeatures)).toString()).format("libsvm").load(path);
                            break block6;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                        dataFrame2 = sqlContext.read().format("libsvm").load(path);
                    }
                    dataFrame = dataFrame2;
                }
                return dataFrame;
            }
            throw new MatchError(option);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad data format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format})));
    }

    public Option<Object> loadData$default$4() {
        return None$.MODULE$;
    }

    public Tuple2<DataFrame, DataFrame> loadDatasets(SparkContext sc, String input, String dataFormat, String testInput, String algo, double fracTest) {
        DataFrame[] dataFrameArray;
        SQLContext sqlContext = new SQLContext(sc);
        DataFrame origExamples = this.loadData(sqlContext, input, dataFormat, this.loadData$default$4());
        String string = testInput;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            dataFrameArray = origExamples.randomSplit(new double[]{1.0 - fracTest, fracTest}, 12345L);
        } else {
            int numFeatures = ((Vector)origExamples.first().getAs(1)).size();
            DataFrame origTestExamples = this.loadData(sqlContext, testInput, dataFormat, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numFeatures)));
            dataFrameArray = (DataFrame[])((Object[])new DataFrame[]{origExamples, origTestExamples});
        }
        DataFrame[] dataframes = dataFrameArray;
        DataFrame training = dataframes[0].cache();
        DataFrame test = dataframes[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        int numFeatures = ((Vector)training.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first().getAs(0)).size();
        Predef$.MODULE$.println((Object)"Loaded data:");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  numTraining = ", ", numTest = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numFeatures)})));
        return new Tuple2((Object)training, (Object)test);
    }

    public void run(DecisionTreeExample.Params params) {
        Tuple2<DataFrame, DataFrame> tuple2;
        block9: {
            block12: {
                block15: {
                    block18: {
                        SparkContext sc;
                        block17: {
                            String string;
                            PipelineModel pipelineModel;
                            String labelColName;
                            DataFrame test;
                            DataFrame training;
                            block16: {
                                String algo;
                                block14: {
                                    BoxedUnit boxedUnit;
                                    String string2;
                                    block13: {
                                        BoxedUnit boxedUnit2;
                                        DecisionTreeClassifier decisionTreeClassifier;
                                        ArrayBuffer stages;
                                        block11: {
                                            String string3;
                                            block10: {
                                                BoxedUnit boxedUnit3;
                                                Tuple2 tuple22;
                                                SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                                                sc = new SparkContext(conf);
                                                params.checkpointDir().foreach((Function1)new Serializable(sc){
                                                    public static final long serialVersionUID = 0L;
                                                    private final SparkContext sc$1;

                                                    public final void apply(String directory) {
                                                        this.sc$1.setCheckpointDir(directory);
                                                    }
                                                    {
                                                        this.sc$1 = sc$1;
                                                    }
                                                });
                                                algo = params.algo().toLowerCase();
                                                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeExample with parameters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                                                tuple2 = this.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), algo, params.fracTest());
                                                if (tuple2 == null) break block9;
                                                DataFrame training2 = (DataFrame)tuple2._1();
                                                DataFrame test2 = (DataFrame)tuple2._2();
                                                if (training2 == null) break block9;
                                                DataFrame dataFrame = training2;
                                                if (test2 == null) break block9;
                                                DataFrame dataFrame2 = test2;
                                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataFrame, (Object)dataFrame2);
                                                training = (DataFrame)tuple23._1();
                                                test = (DataFrame)tuple23._2();
                                                stages = new ArrayBuffer();
                                                String string4 = algo;
                                                String string5 = "classification";
                                                labelColName = !(string4 != null ? !string4.equals(string5) : string5 != null) ? "indexedLabel" : "label";
                                                String string6 = algo;
                                                String string7 = "classification";
                                                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                                    StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol(labelColName);
                                                    boxedUnit3 = stages.$plus$eq((Object)labelIndexer);
                                                } else {
                                                    boxedUnit3 = BoxedUnit.UNIT;
                                                }
                                                VectorIndexer featuresIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(10);
                                                stages.$plus$eq((Object)featuresIndexer);
                                                String string8 = string3 = algo;
                                                if ("classification" != null ? !"classification".equals(string8) : string8 != null) break block10;
                                                decisionTreeClassifier = ((DecisionTreeClassifier)new DecisionTreeClassifier().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval());
                                                break block11;
                                            }
                                            String string9 = string3;
                                            if ("regression" != null ? !"regression".equals(string9) : string9 != null) break block12;
                                            decisionTreeClassifier = ((DecisionTreeRegressor)new DecisionTreeRegressor().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval());
                                        }
                                        DecisionTreeClassifier dt = decisionTreeClassifier;
                                        stages.$plus$eq((Object)dt);
                                        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])stages.toArray(ClassTag$.MODULE$.apply(PipelineStage.class)));
                                        long startTime = System.nanoTime();
                                        pipelineModel = pipeline.fit(training);
                                        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                                        String string10 = string2 = algo;
                                        if ("classification" != null ? !"classification".equals(string10) : string10 != null) break block13;
                                        DecisionTreeClassificationModel treeModel = (DecisionTreeClassificationModel)Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages()).last();
                                        if (treeModel.numNodes() < 20) {
                                            Predef$.MODULE$.println((Object)treeModel.toDebugString());
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            Predef$.MODULE$.println((Object)treeModel);
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit4 = boxedUnit2;
                                        break block14;
                                    }
                                    String string11 = string2;
                                    if ("regression" != null ? !"regression".equals(string11) : string11 != null) break block15;
                                    DecisionTreeRegressionModel treeModel = (DecisionTreeRegressionModel)Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages()).last();
                                    if (treeModel.numNodes() < 20) {
                                        Predef$.MODULE$.println((Object)treeModel.toDebugString());
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        Predef$.MODULE$.println((Object)treeModel);
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit5 = boxedUnit;
                                }
                                String string12 = string = algo;
                                if ("classification" != null ? !"classification".equals(string12) : string12 != null) break block16;
                                Predef$.MODULE$.println((Object)"Training data results:");
                                this.evaluateClassificationModel((Transformer)pipelineModel, training, labelColName);
                                Predef$.MODULE$.println((Object)"Test data results:");
                                this.evaluateClassificationModel((Transformer)pipelineModel, test, labelColName);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block17;
                            }
                            String string13 = string;
                            if ("regression" != null ? !"regression".equals(string13) : string13 != null) break block18;
                            Predef$.MODULE$.println((Object)"Training data results:");
                            this.evaluateRegressionModel((Transformer)pipelineModel, training, labelColName);
                            Predef$.MODULE$.println((Object)"Test data results:");
                            this.evaluateRegressionModel((Transformer)pipelineModel, test, labelColName);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        sc.stop();
                        return;
                    }
                    throw new IllegalArgumentException("Algo ${params.algo} not supported.");
                }
                throw new IllegalArgumentException("Algo ${params.algo} not supported.");
            }
            throw new IllegalArgumentException("Algo ${params.algo} not supported.");
        }
        throw new MatchError(tuple2);
    }

    public void evaluateClassificationModel(Transformer model, DataFrame data, String labelColName) {
        DataFrame fullPredictions = model.transform(data).cache();
        RDD predictions = fullPredictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row x$2) {
                return x$2.getDouble(0);
            }
        }, ClassTag$.MODULE$.Double());
        RDD labels = fullPredictions.select(labelColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row x$3) {
                return x$3.getDouble(0);
            }
        }, ClassTag$.MODULE$.Double());
        Option option = MetadataUtils$.MODULE$.getNumClasses(fullPredictions.schema().apply(labelColName));
        if (option instanceof Some) {
            int n;
            int n2;
            Some some = (Some)option;
            int numClasses = n2 = (n = BoxesRunTime.unboxToInt((Object)some.x()));
            double accuracy = new MulticlassMetrics(predictions.zip(labels, ClassTag$.MODULE$.Double())).precision();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Accuracy (", " classes): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses), BoxesRunTime.boxToDouble((double)accuracy)})));
            return;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new RuntimeException("Unknown failure when indexing labels for classification.");
        }
        throw new MatchError((Object)option);
    }

    public void evaluateRegressionModel(Transformer model, DataFrame data, String labelColName) {
        DataFrame fullPredictions = model.transform(data).cache();
        RDD predictions = fullPredictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row x$4) {
                return x$4.getDouble(0);
            }
        }, ClassTag$.MODULE$.Double());
        RDD labels = fullPredictions.select(labelColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row x$5) {
                return x$5.getDouble(0);
            }
        }, ClassTag$.MODULE$.Double());
        double RMSE = new RegressionMetrics(predictions.zip(labels, ClassTag$.MODULE$.Double())).rootMeanSquaredError();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Root mean squared error (RMSE): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)RMSE)})));
    }

    private DecisionTreeExample$() {
        MODULE$ = this;
    }
}

