/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.examples.SparkALS$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SparkALS$ {
    public static final SparkALS$ MODULE$;
    private int M;
    private int U;
    private int F;
    private int ITERATIONS;
    private final double LAMBDA;

    static {
        new SparkALS$();
    }

    public int M() {
        return this.M;
    }

    public void M_$eq(int x$1) {
        this.M = x$1;
    }

    public int U() {
        return this.U;
    }

    public void U_$eq(int x$1) {
        this.U = x$1;
    }

    public int F() {
        return this.F;
    }

    public void F_$eq(int x$1) {
        this.F = x$1;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        this.ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return this.LAMBDA;
    }

    public RealMatrix generateR() {
        RealMatrix mh = this.randomMatrix(this.M(), this.F());
        RealMatrix uh = this.randomMatrix(this.U(), this.F());
        return mh.multiply(uh.transpose());
    }

    public double rmse(RealMatrix targetR, RealVector[] ms, RealVector[] us) {
        Array2DRowRealMatrix r = new Array2DRowRealMatrix(this.M(), this.U());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(ms, us, r){
            public static final long serialVersionUID = 0L;
            public final RealVector[] ms$1;
            public final RealVector[] us$1;
            public final Array2DRowRealMatrix r$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.1 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.r$1.setEntry(this.i$2, j, this.$outer.ms$1[this.i$2].dotProduct(this.$outer.us$1[j]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.ms$1 = ms$1;
                this.us$1 = us$1;
                this.r$1 = r$1;
            }
        });
        RealMatrix diffs = r.subtract(targetR);
        DoubleRef sumSqs = new DoubleRef(0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(diffs, sumSqs){
            public static final long serialVersionUID = 0L;
            public final RealMatrix diffs$1;
            public final DoubleRef sumSqs$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.2 $outer;
                    private final int i$3;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        double diff = this.$outer.diffs$1.getEntry(this.i$3, j);
                        this.$outer.sumSqs$1.elem += diff * diff;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$3 = i$3;
                    }
                });
            }
            {
                this.diffs$1 = diffs$1;
                this.sumSqs$1 = sumSqs$1;
            }
        });
        return package$.MODULE$.sqrt(sumSqs.elem / ((double)this.M() * (double)this.U()));
    }

    public RealVector update(int i, RealVector m, RealVector[] us, RealMatrix R) {
        int U = Predef$.MODULE$.refArrayOps((Object[])us).size();
        int F = us[0].getDimension();
        ObjectRef XtX = new ObjectRef((Object)new Array2DRowRealMatrix(F, F));
        ObjectRef Xty = new ObjectRef((Object)new ArrayRealVector(F));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), U).foreach$mVc$sp((Function1)new Serializable(i, us, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int i$1;
            private final RealVector[] us$2;
            private final RealMatrix R$1;
            private final ObjectRef XtX$1;
            private final ObjectRef Xty$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                RealVector u = this.us$2[j];
                this.XtX$1.elem = ((RealMatrix)this.XtX$1.elem).add(u.outerProduct(u));
                this.Xty$1.elem = ((RealVector)this.Xty$1.elem).add(u.mapMultiply(this.R$1.getEntry(this.i$1, j)));
            }
            {
                this.i$1 = i$1;
                this.us$2 = us$2;
                this.R$1 = R$1;
                this.XtX$1 = XtX$1;
                this.Xty$1 = Xty$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), F).foreach$mVc$sp((Function1)new Serializable(U, XtX){
            public static final long serialVersionUID = 0L;
            private final int U$1;
            private final ObjectRef XtX$1;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                ((RealMatrix)this.XtX$1.elem).addToEntry(d, d, SparkALS$.MODULE$.LAMBDA() * (double)this.U$1);
            }
            {
                this.U$1 = U$1;
                this.XtX$1 = XtX$1;
            }
        });
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of ALS and is given as an example!\n        |Please use the ALS method found in org.apache.spark.mllib.recommendation\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        IntRef slices = new IntRef(0);
        IndexedSeq options = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final Option<String> apply(int i) {
                return i < this.args$1.length ? new Some((Object)this.args$1[i]) : None$.MODULE$;
            }
            {
                this.args$1 = args$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Option[] optionArray = (Option[])options.toArray(ClassTag$.MODULE$.apply(Option.class));
        Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(5) == 0) {
            Option m = (Option)((SeqLike)option.get()).apply(0);
            Option u = (Option)((SeqLike)option.get()).apply(1);
            Option f = (Option)((SeqLike)option.get()).apply(2);
            Option iters = (Option)((SeqLike)option.get()).apply(3);
            Option slices_ = (Option)((SeqLike)option.get()).apply(4);
            this.M_$eq(new StringOps(Predef$.MODULE$.augmentString((String)m.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "100";
                }
            }))).toInt());
            this.U_$eq(new StringOps(Predef$.MODULE$.augmentString((String)u.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "500";
                }
            }))).toInt());
            this.F_$eq(new StringOps(Predef$.MODULE$.augmentString((String)f.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "10";
                }
            }))).toInt());
            this.ITERATIONS_$eq(new StringOps(Predef$.MODULE$.augmentString((String)iters.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "5";
                }
            }))).toInt());
            slices.elem = new StringOps(Predef$.MODULE$.augmentString((String)slices_.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "2";
                }
            }))).toInt();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.err.println("Usage: SparkALS [M] [U] [F] [iters] [slices]");
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.showWarning();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running with M=", ", U=", ", F=", ", iters=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.M()), BoxesRunTime.boxToInteger((int)this.U()), BoxesRunTime.boxToInteger((int)this.F()), BoxesRunTime.boxToInteger((int)this.ITERATIONS())})));
        SparkConf sparkConf = new SparkConf().setAppName("SparkALS");
        SparkContext sc = new SparkContext(sparkConf);
        RealMatrix R = this.generateR();
        ObjectRef ms = new ObjectRef((Object)((RealVector[])Array$.MODULE$.fill(this.M(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RealVector apply() {
                return SparkALS$.MODULE$.org$apache$spark$examples$SparkALS$$randomVector(SparkALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(RealVector.class))));
        ObjectRef us = new ObjectRef((Object)((RealVector[])Array$.MODULE$.fill(this.U(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RealVector apply() {
                return SparkALS$.MODULE$.org$apache$spark$examples$SparkALS$$randomVector(SparkALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(RealVector.class))));
        Broadcast Rc = sc.broadcast((Object)R, ClassTag$.MODULE$.apply(RealMatrix.class));
        ObjectRef msb = new ObjectRef((Object)sc.broadcast((Object)((RealVector[])ms.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class))));
        ObjectRef usb = new ObjectRef((Object)sc.broadcast((Object)((RealVector[])us.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)new Serializable(slices, sc, R, ms, us, Rc, msb, usb){
            public static final long serialVersionUID = 0L;
            private final IntRef slices$1;
            private final SparkContext sc$1;
            private final RealMatrix R$2;
            private final ObjectRef ms$2;
            private final ObjectRef us$3;
            public final Broadcast Rc$1;
            public final ObjectRef msb$1;
            public final ObjectRef usb$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iter)})));
                this.ms$2.elem = (RealVector[])this.sc$1.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.M()), this.slices$1.elem, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final RealVector apply(int i) {
                        return SparkALS$.MODULE$.update(i, ((RealVector[])((Broadcast)this.$outer.msb$1.elem).value())[i], (RealVector[])((Broadcast)this.$outer.usb$1.elem).value(), (RealMatrix)this.$outer.Rc$1.value());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(RealVector.class)).collect();
                this.msb$1.elem = this.sc$1.broadcast((Object)((RealVector[])this.ms$2.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class)));
                this.us$3.elem = (RealVector[])this.sc$1.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.U()), this.slices$1.elem, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final RealVector apply(int i) {
                        return SparkALS$.MODULE$.update(i, ((RealVector[])((Broadcast)this.$outer.usb$1.elem).value())[i], (RealVector[])((Broadcast)this.$outer.msb$1.elem).value(), ((RealMatrix)this.$outer.Rc$1.value()).transpose());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(RealVector.class)).collect();
                this.usb$1.elem = this.sc$1.broadcast((Object)((RealVector[])this.us$3.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class)));
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"RMSE = ").append((Object)BoxesRunTime.boxToDouble((double)SparkALS$.MODULE$.rmse(this.R$2, (RealVector[])this.ms$2.elem, (RealVector[])this.us$3.elem))).toString());
                Predef$.MODULE$.println();
            }
            {
                this.slices$1 = slices$1;
                this.sc$1 = sc$1;
                this.R$2 = R$2;
                this.ms$2 = ms$2;
                this.us$3 = us$3;
                this.Rc$1 = Rc$1;
                this.msb$1 = msb$1;
                this.usb$1 = usb$1;
            }
        });
        sc.stop();
    }

    public RealVector org$apache$spark$examples$SparkALS$$randomVector(int n) {
        return new ArrayRealVector((double[])Array$.MODULE$.fill(n, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return package$.MODULE$.random();
            }
        }, ClassTag$.MODULE$.Double()));
    }

    private RealMatrix randomMatrix(int rows, int cols) {
        return new Array2DRowRealMatrix((double[][])Array$.MODULE$.fill(rows, cols, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return package$.MODULE$.random();
            }
        }, ClassTag$.MODULE$.Double()));
    }

    private SparkALS$() {
        MODULE$ = this;
        this.M = 0;
        this.U = 0;
        this.F = 0;
        this.ITERATIONS = 0;
        this.LAMBDA = 0.01;
    }
}

