/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;

public final class HBaseTest$ {
    public static final HBaseTest$ MODULE$;

    static {
        new HBaseTest$();
    }

    public void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("HBaseTest");
        SparkContext sc = new SparkContext(sparkConf);
        Configuration conf = HBaseConfiguration.create();
        if (args.length < 1) {
            System.err.println("Usage: HBaseTest <table_name>");
            System.exit(1);
        }
        conf.set("hbase.mapreduce.inputtable", args[0]);
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (!admin.isTableAvailable(args[0])) {
            HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)args[0]));
            admin.createTable(tableDesc);
        }
        RDD hBaseRDD = sc.newAPIHadoopRDD(conf, TableInputFormat.class, ImmutableBytesWritable.class, Result.class);
        hBaseRDD.count();
        sc.stop();
        admin.close();
    }

    private HBaseTest$() {
        MODULE$ = this;
    }
}

