/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.flume.FlumeUtils;

public final class JavaFlumeEventCount {
    private JavaFlumeEventCount() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: JavaFlumeEventCount <host> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        Duration batchInterval = new Duration(2000L);
        SparkConf sparkConf = new SparkConf().setAppName("JavaFlumeEventCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, batchInterval);
        JavaReceiverInputDStream flumeStream = FlumeUtils.createStream((JavaStreamingContext)ssc, (String)host, (int)port);
        flumeStream.count();
        flumeStream.count().map((Function)new Function<Long, String>(){

            public String call(Long in) {
                return "Received " + in + " flume events.";
            }
        }).print();
        ssc.start();
        ssc.awaitTermination();
    }
}

