/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Tuple2;

public class JavaCustomReceiver
extends Receiver<String> {
    private static final Pattern SPACE = Pattern.compile(" ");
    String host = null;
    int port = -1;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: JavaCustomReceiver <hostname> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaCustomReceiver");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, new Duration(1000L));
        JavaReceiverInputDStream lines = ssc.receiverStream((Receiver)new JavaCustomReceiver(args[0], Integer.parseInt(args[1])));
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String x) {
                return Lists.newArrayList((Object[])SPACE.split(x));
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        ssc.start();
        ssc.awaitTermination();
    }

    public JavaCustomReceiver(String host_, int port_) {
        super(StorageLevel.MEMORY_AND_DISK_2());
        this.host = host_;
        this.port = port_;
    }

    public void onStart() {
        new Thread(){

            @Override
            public void run() {
                JavaCustomReceiver.this.receive();
            }
        }.start();
    }

    public void onStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() {
        try {
            Socket socket = null;
            BufferedReader reader = null;
            String userInput = null;
            try {
                socket = new Socket(this.host, this.port);
                reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while (!this.isStopped() && (userInput = reader.readLine()) != null) {
                    System.out.println("Received data '" + userInput + "'");
                    this.store(userInput);
                }
            }
            catch (Throwable throwable) {
                Closeables.close(reader, (boolean)true);
                Closeables.close((Closeable)socket, (boolean)true);
                throw throwable;
            }
            Closeables.close((Closeable)reader, (boolean)true);
            Closeables.close((Closeable)socket, (boolean)true);
            this.restart("Trying to connect again");
        }
        catch (ConnectException ce) {
            this.restart("Could not connect", ce);
        }
        catch (Throwable t) {
            this.restart("Error receiving data", t);
        }
    }
}

